/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.common.util;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.somda.sdc.common.util.Stringified;

public class ObjectStringifier {
    public static <T> String stringify(T obj) {
        return ObjectStringifier.stringifyWithFilter(obj, null, field -> field.isAnnotationPresent(Stringified.class));
    }

    public static <T> String stringify(T obj, SortedMap<String, Object> keyValues) {
        return ObjectStringifier.stringifyWithFilter(obj, keyValues, field -> field.isAnnotationPresent(Stringified.class));
    }

    public static <T> String stringify(T obj, String[] fieldNames) {
        return ObjectStringifier.stringifyWithFilter(obj, null, field -> {
            for (String fieldName : fieldNames) {
                if (!field.getName().equals(fieldName)) continue;
                return true;
            }
            return false;
        });
    }

    public static <T> String stringify(T obj, String[] fieldNames, SortedMap<String, Object> keyValues) {
        return ObjectStringifier.stringifyWithFilter(obj, keyValues, field -> {
            for (String fieldName : fieldNames) {
                if (!field.getName().equals(fieldName)) continue;
                return true;
            }
            return false;
        });
    }

    public static <T> String stringifyMap(T obj, SortedMap<String, Object> keyValues) {
        StringBuilder stringBuilder = ObjectStringifier.start(obj);
        ObjectStringifier.appendMapValues(stringBuilder, keyValues);
        return ObjectStringifier.finish(stringBuilder);
    }

    public static <T> String stringifyAll(T obj) {
        return ObjectStringifier.stringifyWithFilter(obj, null, field -> !field.getName().startsWith("this$"));
    }

    private static void appendMapValues(StringBuilder stringBuilder, SortedMap<String, Object> keyValues) {
        Iterator<Map.Entry<String, Object>> iterator = keyValues.entrySet().iterator();
        boolean firstRun = true;
        while (iterator.hasNext()) {
            if (!firstRun) {
                stringBuilder.append(';');
            }
            firstRun = false;
            Map.Entry<String, Object> next = iterator.next();
            ObjectStringifier.appendKeyValue(stringBuilder, next.getKey(), next.getValue());
        }
    }

    private static <T> String stringifyWithFilter(T obj, @Nullable SortedMap<String, Object> keyValues, Predicate<Field> filter) {
        StringBuilder stringBuilder = ObjectStringifier.start(obj);
        try {
            ObjectStringifier.appendToStringProperties(stringBuilder, obj, filter);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (keyValues != null && !keyValues.isEmpty()) {
            stringBuilder.append(';');
            ObjectStringifier.appendMapValues(stringBuilder, keyValues);
        }
        return ObjectStringifier.finish(stringBuilder);
    }

    private static <T> StringBuilder start(T obj) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(obj.getClass().getSimpleName());
        stringBuilder.append("(");
        return stringBuilder;
    }

    private static String finish(StringBuilder stringBuilder) {
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static void appendToStringProperties(StringBuilder stringBuilder, Object obj, Predicate<Field> predicate) throws IllegalAccessException {
        Field[] fields = obj.getClass().getDeclaredFields();
        int insertedFields = 0;
        for (Field field : fields) {
            field.setAccessible(true);
            if (!predicate.test(field)) continue;
            if (insertedFields++ > 0) {
                stringBuilder.append(';');
            }
            ObjectStringifier.appendKeyValue(stringBuilder, field.getName(), field.get(obj));
        }
    }

    private static void appendKeyValue(StringBuilder stringBuilder, String key, @Nullable Object value) {
        stringBuilder.append(key);
        stringBuilder.append('=');
        stringBuilder.append(value);
    }
}

