/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.common.util;

import com.google.common.util.concurrent.AbstractIdleService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.model.ObjectStringifier;
import org.somda.sdc.common.model.Stringified;

public class ExecutorWrapperService<T extends ExecutorService>
extends AbstractIdleService {
    private static final Logger LOG = LogManager.getLogger(ExecutorWrapperService.class);
    private static final long STOP_TIMEOUT = 5L;
    private static final TimeUnit STOP_TIMEUNIT = TimeUnit.SECONDS;
    private final Callable<T> serviceCreator;
    @Stringified
    private final String serviceName;
    private final Logger instanceLogger;
    @Stringified
    private T executorService;

    public ExecutorWrapperService(Callable<T> serviceCreator, String serviceName, String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger(LOG, frameworkIdentifier);
        this.serviceCreator = serviceCreator;
        this.serviceName = serviceName;
    }

    protected void startUp() throws Exception {
        this.instanceLogger.debug("[{}] Starting executor service wrapper", (Object)this.serviceName);
        this.executorService = (ExecutorService)this.serviceCreator.call();
    }

    protected void shutDown() throws Exception {
        this.instanceLogger.info("[{}] Stopping executor service wrapper", (Object)this.serviceName);
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(5L, STOP_TIMEUNIT);
            }
            catch (InterruptedException e) {
                this.instanceLogger.error("[{}] Could not stop all threads!", (Object)this.serviceName);
                throw e;
            }
        }
    }

    public T get() {
        if (this.isRunning()) {
            return this.executorService;
        }
        this.instanceLogger.error("[{}] get was called on a service which was not running", (Object)this.serviceName);
        throw new RuntimeException(String.format("ExecutorWrapperService.get() called on %s service which was not running", this.serviceName));
    }

    public String toString() {
        return ObjectStringifier.stringify((Object)((Object)this)) + " [" + String.valueOf(this.state()) + "]";
    }
}

