/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.common.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrefixNamespaceMappingParser {
    private static final Logger LOG = LogManager.getLogger(PrefixNamespaceMappingParser.class);

    PrefixNamespaceMappingParser() {
    }

    public Map<String, PrefixNamespacePair> parse(String prefixNamespaces) {
        HashMap<String, PrefixNamespacePair> mapping = new HashMap<String, PrefixNamespacePair>();
        Pattern pattern = Pattern.compile("\\{(.+?):(.+?)\\}");
        Matcher matcher = pattern.matcher(prefixNamespaces);
        while (matcher.find()) {
            String prefix = matcher.group(1);
            String uri = matcher.group(2);
            try {
                mapping.put(uri, new PrefixNamespacePair(prefix, new URI(uri).toString()));
            }
            catch (URISyntaxException e) {
                LOG.warn("Given namespace in {} is not a valid URI: {}", (Object)prefixNamespaces, (Object)uri);
            }
        }
        return mapping;
    }

    public static class PrefixNamespacePair {
        private final String prefix;
        private final String namespace;

        public PrefixNamespacePair(String prefix, String namespace) {
            this.prefix = prefix;
            this.namespace = namespace;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String toString() {
            return String.format("{%s:%s}", this.prefix, this.namespace);
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs instanceof PrefixNamespacePair) {
                PrefixNamespacePair castRhs = (PrefixNamespacePair)rhs;
                return this.prefix.equals(castRhs.prefix) && this.namespace.equals(castRhs.namespace);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.namespace);
        }
    }
}

