/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.jaxb;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyTree {
    private final Map<String, PropertyTree> children;
    private final String propertyName;

    public static Builder builder() {
        return new Builder();
    }

    public PropertyTree(String propertyName, Map<String, PropertyTree> children) {
        this.propertyName = propertyName;
        this.children = Collections.unmodifiableMap(children);
    }

    public PropertyTree get(String propertyName) {
        return this.isLeaf() ? null : this.children.get(propertyName);
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public String propertyName() {
        return this.propertyName;
    }

    public static final class Builder {
        private final Map<String, Builder> children = new LinkedHashMap<String, Builder>();
        private final Builder parent;
        private final String propertyName;

        public Builder() {
            this(null, null);
        }

        private Builder(Builder parent, String propertyName) {
            this.parent = parent;
            this.propertyName = propertyName;
        }

        public Builder with(String propertyName) {
            Builder child = this.children.get(propertyName);
            if (child == null) {
                child = new Builder(this, propertyName);
                this.children.put(propertyName, child);
            }
            return child;
        }

        public PropertyTree build() {
            if (this.parent != null) {
                return this.parent.build();
            }
            return new PropertyTree(this.propertyName, this.buildChildren());
        }

        private Map<String, PropertyTree> buildChildren() {
            LinkedHashMap<String, PropertyTree> childProducts = new LinkedHashMap<String, PropertyTree>(this.children.size());
            for (Builder childBuilder : this.children.values()) {
                PropertyTree child = new PropertyTree(childBuilder.propertyName, childBuilder.buildChildren());
                childProducts.put(child.propertyName, child);
            }
            return Collections.unmodifiableMap(childProducts);
        }

        public Builder parent() {
            return this.parent;
        }

        public Builder root() {
            if (this.parent != null) {
                return this.parent.root();
            }
            return this;
        }
    }
}

