
package org.somda.sdc.dpws.soap.wsdiscovery.model;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Java class for AppSequenceType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="AppSequenceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="InstanceId" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" />
 *       <attribute name="SequenceId" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *       <attribute name="MessageNumber" use="required" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" />
 *       <anyAttribute processContents='lax' namespace='##other'/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AppSequenceType", namespace = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01")
public class AppSequenceType implements Cloneable, CopyTo, ToString
{

    @XmlAttribute(name = "InstanceId", required = true)
    @XmlSchemaType(name = "unsignedInt")
    protected long instanceId;
    @XmlAttribute(name = "SequenceId")
    @XmlSchemaType(name = "anyURI")
    protected String sequenceId;
    @XmlAttribute(name = "MessageNumber", required = true)
    @XmlSchemaType(name = "unsignedInt")
    protected long messageNumber;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<>();

    /**
     * Gets the value of the instanceId property.
     * 
     */
    public long getInstanceId() {
        return instanceId;
    }

    /**
     * Sets the value of the instanceId property.
     * 
     */
    public void setInstanceId(long value) {
        this.instanceId = value;
    }

    /**
     * Gets the value of the sequenceId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSequenceId() {
        return sequenceId;
    }

    /**
     * Sets the value of the sequenceId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSequenceId(String value) {
        this.sequenceId = value;
    }

    /**
     * Gets the value of the messageNumber property.
     * 
     */
    public long getMessageNumber() {
        return messageNumber;
    }

    /**
     * Sets the value of the messageNumber property.
     * 
     */
    public void setMessageNumber(long value) {
        this.messageNumber = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final AppSequenceType that = ((AppSequenceType) object);
        {
            long leftInstanceId;
            leftInstanceId = this.getInstanceId();
            long rightInstanceId;
            rightInstanceId = that.getInstanceId();
            if (leftInstanceId!= rightInstanceId) {
                return false;
            }
        }
        {
            String leftSequenceId;
            leftSequenceId = this.getSequenceId();
            String rightSequenceId;
            rightSequenceId = that.getSequenceId();
            if (this.sequenceId!= null) {
                if (that.sequenceId!= null) {
                    if (!leftSequenceId.equals(rightSequenceId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.sequenceId!= null) {
                    return false;
                }
            }
        }
        {
            long leftMessageNumber;
            leftMessageNumber = this.getMessageNumber();
            long rightMessageNumber;
            rightMessageNumber = that.getMessageNumber();
            if (leftMessageNumber!= rightMessageNumber) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            long theInstanceId;
            theInstanceId = this.getInstanceId();
            currentHashCode += ((int)(theInstanceId^(theInstanceId >>> 32)));
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theSequenceId;
            theSequenceId = this.getSequenceId();
            if (this.sequenceId!= null) {
                currentHashCode += theSequenceId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            long theMessageNumber;
            theMessageNumber = this.getMessageNumber();
            currentHashCode += ((int)(theMessageNumber^(theMessageNumber >>> 32)));
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            long theInstanceId;
            theInstanceId = this.getInstanceId();
            strategy.appendField(locator, this, "instanceId", buffer, theInstanceId, true);
        }
        {
            String theSequenceId;
            theSequenceId = this.getSequenceId();
            strategy.appendField(locator, this, "sequenceId", buffer, theSequenceId, (this.sequenceId!= null));
        }
        {
            long theMessageNumber;
            theMessageNumber = this.getMessageNumber();
            strategy.appendField(locator, this, "messageNumber", buffer, theMessageNumber, true);
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof AppSequenceType) {
            final AppSequenceType copy = ((AppSequenceType) draftCopy);
            {
                Boolean instanceIdShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, true);
                if (instanceIdShouldBeCopiedAndSet == Boolean.TRUE) {
                    long sourceInstanceId;
                    sourceInstanceId = this.getInstanceId();
                    long copyInstanceId = strategy.copy(LocatorUtils.property(locator, "instanceId", sourceInstanceId), sourceInstanceId, true);
                    copy.setInstanceId(copyInstanceId);
                } else {
                    if (instanceIdShouldBeCopiedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean sequenceIdShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.sequenceId!= null));
                if (sequenceIdShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceSequenceId;
                    sourceSequenceId = this.getSequenceId();
                    String copySequenceId = ((String) strategy.copy(LocatorUtils.property(locator, "sequenceId", sourceSequenceId), sourceSequenceId, (this.sequenceId!= null)));
                    copy.setSequenceId(copySequenceId);
                } else {
                    if (sequenceIdShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.sequenceId = null;
                    }
                }
            }
            {
                Boolean messageNumberShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, true);
                if (messageNumberShouldBeCopiedAndSet == Boolean.TRUE) {
                    long sourceMessageNumber;
                    sourceMessageNumber = this.getMessageNumber();
                    long copyMessageNumber = strategy.copy(LocatorUtils.property(locator, "messageNumber", sourceMessageNumber), sourceMessageNumber, true);
                    copy.setMessageNumber(copyMessageNumber);
                } else {
                    if (messageNumberShouldBeCopiedAndSet == Boolean.FALSE) {
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new AppSequenceType();
    }

}
