
package org.somda.sdc.dpws.soap.wsaddressing.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;
import org.w3c.dom.Element;


/**
 * <p>Java class for EndpointReferenceType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="EndpointReferenceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="Address" type="{http://www.w3.org/2005/08/addressing}AttributedURIType"/>
 *         <element ref="{http://www.w3.org/2005/08/addressing}ReferenceParameters" minOccurs="0"/>
 *         <element ref="{http://www.w3.org/2005/08/addressing}Metadata" minOccurs="0"/>
 *         <any processContents='lax' namespace='##other' maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <anyAttribute processContents='lax' namespace='##other'/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EndpointReferenceType", namespace = "http://www.w3.org/2005/08/addressing", propOrder = {
    "address",
    "referenceParameters",
    "metadata",
    "any"
})
public class EndpointReferenceType implements Cloneable, CopyTo, ToString
{

    @XmlElement(name = "Address", namespace = "http://www.w3.org/2005/08/addressing", required = true)
    protected AttributedURIType address;
    @XmlElement(name = "ReferenceParameters", namespace = "http://www.w3.org/2005/08/addressing")
    protected ReferenceParametersType referenceParameters;
    @XmlElement(name = "Metadata", namespace = "http://www.w3.org/2005/08/addressing")
    protected MetadataType metadata;
    @XmlAnyElement(lax = true)
    protected List<Object> any;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<>();

    /**
     * Gets the value of the address property.
     * 
     * @return
     *     possible object is
     *     {@link AttributedURIType }
     *     
     */
    public AttributedURIType getAddress() {
        return address;
    }

    /**
     * Sets the value of the address property.
     * 
     * @param value
     *     allowed object is
     *     {@link AttributedURIType }
     *     
     */
    public void setAddress(AttributedURIType value) {
        this.address = value;
    }

    /**
     * Gets the value of the referenceParameters property.
     * 
     * @return
     *     possible object is
     *     {@link ReferenceParametersType }
     *     
     */
    public ReferenceParametersType getReferenceParameters() {
        return referenceParameters;
    }

    /**
     * Sets the value of the referenceParameters property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferenceParametersType }
     *     
     */
    public void setReferenceParameters(ReferenceParametersType value) {
        this.referenceParameters = value;
    }

    /**
     * Gets the value of the metadata property.
     * 
     * @return
     *     possible object is
     *     {@link MetadataType }
     *     
     */
    public MetadataType getMetadata() {
        return metadata;
    }

    /**
     * Sets the value of the metadata property.
     * 
     * @param value
     *     allowed object is
     *     {@link MetadataType }
     *     
     */
    public void setMetadata(MetadataType value) {
        this.metadata = value;
    }

    /**
     * Gets the value of the any property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the any property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAny().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * {@link Element }
     * </p>
     * 
     * 
     * @return
     *     The value of the any property.
     */
    public List<Object> getAny() {
        if (any == null) {
            any = new ArrayList<>();
        }
        return this.any;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    public void setAny(List<Object> value) {
        this.any = null;
        if (value!= null) {
            List<Object> draftl = this.getAny();
            draftl.addAll(value);
        }
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final EndpointReferenceType that = ((EndpointReferenceType) object);
        {
            AttributedURIType leftAddress;
            leftAddress = this.getAddress();
            AttributedURIType rightAddress;
            rightAddress = that.getAddress();
            if (this.address!= null) {
                if (that.address!= null) {
                    if (!leftAddress.equals(rightAddress)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.address!= null) {
                    return false;
                }
            }
        }
        {
            ReferenceParametersType leftReferenceParameters;
            leftReferenceParameters = this.getReferenceParameters();
            ReferenceParametersType rightReferenceParameters;
            rightReferenceParameters = that.getReferenceParameters();
            if (this.referenceParameters!= null) {
                if (that.referenceParameters!= null) {
                    if (!leftReferenceParameters.equals(rightReferenceParameters)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.referenceParameters!= null) {
                    return false;
                }
            }
        }
        {
            MetadataType leftMetadata;
            leftMetadata = this.getMetadata();
            MetadataType rightMetadata;
            rightMetadata = that.getMetadata();
            if (this.metadata!= null) {
                if (that.metadata!= null) {
                    if (!leftMetadata.equals(rightMetadata)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.metadata!= null) {
                    return false;
                }
            }
        }
        {
            List<Object> leftAny;
            leftAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            List<Object> rightAny;
            rightAny = (((that.any!= null)&&(!that.any.isEmpty()))?that.getAny():null);
            if ((this.any!= null)&&(!this.any.isEmpty())) {
                if ((that.any!= null)&&(!that.any.isEmpty())) {
                    if (!leftAny.equals(rightAny)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.any!= null)&&(!that.any.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            AttributedURIType theAddress;
            theAddress = this.getAddress();
            if (this.address!= null) {
                currentHashCode += theAddress.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ReferenceParametersType theReferenceParameters;
            theReferenceParameters = this.getReferenceParameters();
            if (this.referenceParameters!= null) {
                currentHashCode += theReferenceParameters.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            MetadataType theMetadata;
            theMetadata = this.getMetadata();
            if (this.metadata!= null) {
                currentHashCode += theMetadata.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Object> theAny;
            theAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            if ((this.any!= null)&&(!this.any.isEmpty())) {
                currentHashCode += theAny.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            AttributedURIType theAddress;
            theAddress = this.getAddress();
            strategy.appendField(locator, this, "address", buffer, theAddress, (this.address!= null));
        }
        {
            ReferenceParametersType theReferenceParameters;
            theReferenceParameters = this.getReferenceParameters();
            strategy.appendField(locator, this, "referenceParameters", buffer, theReferenceParameters, (this.referenceParameters!= null));
        }
        {
            MetadataType theMetadata;
            theMetadata = this.getMetadata();
            strategy.appendField(locator, this, "metadata", buffer, theMetadata, (this.metadata!= null));
        }
        {
            List<Object> theAny;
            theAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            strategy.appendField(locator, this, "any", buffer, theAny, ((this.any!= null)&&(!this.any.isEmpty())));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof EndpointReferenceType) {
            final EndpointReferenceType copy = ((EndpointReferenceType) draftCopy);
            {
                Boolean addressShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.address!= null));
                if (addressShouldBeCopiedAndSet == Boolean.TRUE) {
                    AttributedURIType sourceAddress;
                    sourceAddress = this.getAddress();
                    AttributedURIType copyAddress = ((AttributedURIType) strategy.copy(LocatorUtils.property(locator, "address", sourceAddress), sourceAddress, (this.address!= null)));
                    copy.setAddress(copyAddress);
                } else {
                    if (addressShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.address = null;
                    }
                }
            }
            {
                Boolean referenceParametersShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.referenceParameters!= null));
                if (referenceParametersShouldBeCopiedAndSet == Boolean.TRUE) {
                    ReferenceParametersType sourceReferenceParameters;
                    sourceReferenceParameters = this.getReferenceParameters();
                    ReferenceParametersType copyReferenceParameters = ((ReferenceParametersType) strategy.copy(LocatorUtils.property(locator, "referenceParameters", sourceReferenceParameters), sourceReferenceParameters, (this.referenceParameters!= null)));
                    copy.setReferenceParameters(copyReferenceParameters);
                } else {
                    if (referenceParametersShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.referenceParameters = null;
                    }
                }
            }
            {
                Boolean metadataShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.metadata!= null));
                if (metadataShouldBeCopiedAndSet == Boolean.TRUE) {
                    MetadataType sourceMetadata;
                    sourceMetadata = this.getMetadata();
                    MetadataType copyMetadata = ((MetadataType) strategy.copy(LocatorUtils.property(locator, "metadata", sourceMetadata), sourceMetadata, (this.metadata!= null)));
                    copy.setMetadata(copyMetadata);
                } else {
                    if (metadataShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.metadata = null;
                    }
                }
            }
            {
                Boolean anyShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, ((this.any!= null)&&(!this.any.isEmpty())));
                if (anyShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<Object> sourceAny;
                    sourceAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
                    @SuppressWarnings("unchecked")
                    List<Object> copyAny = ((List<Object> ) strategy.copy(LocatorUtils.property(locator, "any", sourceAny), sourceAny, ((this.any!= null)&&(!this.any.isEmpty()))));
                    copy.setAny(copyAny);
                } else {
                    if (anyShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.any = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new EndpointReferenceType();
    }

}
