
package org.somda.sdc.dpws.soap.wsaddressing.model;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Java class for ProblemActionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ProblemActionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{http://www.w3.org/2005/08/addressing}Action" minOccurs="0"/>
 *         <element name="SoapAction" type="{http://www.w3.org/2001/XMLSchema}anyURI" minOccurs="0"/>
 *       </sequence>
 *       <anyAttribute processContents='lax' namespace='##other'/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ProblemActionType", namespace = "http://www.w3.org/2005/08/addressing", propOrder = {
    "action",
    "soapAction"
})
public class ProblemActionType implements Cloneable, CopyTo, ToString
{

    @XmlElement(name = "Action", namespace = "http://www.w3.org/2005/08/addressing")
    protected AttributedURIType action;
    @XmlElement(name = "SoapAction", namespace = "http://www.w3.org/2005/08/addressing")
    @XmlSchemaType(name = "anyURI")
    protected String soapAction;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<>();

    /**
     * Gets the value of the action property.
     * 
     * @return
     *     possible object is
     *     {@link AttributedURIType }
     *     
     */
    public AttributedURIType getAction() {
        return action;
    }

    /**
     * Sets the value of the action property.
     * 
     * @param value
     *     allowed object is
     *     {@link AttributedURIType }
     *     
     */
    public void setAction(AttributedURIType value) {
        this.action = value;
    }

    /**
     * Gets the value of the soapAction property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSoapAction() {
        return soapAction;
    }

    /**
     * Sets the value of the soapAction property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSoapAction(String value) {
        this.soapAction = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ProblemActionType that = ((ProblemActionType) object);
        {
            AttributedURIType leftAction;
            leftAction = this.getAction();
            AttributedURIType rightAction;
            rightAction = that.getAction();
            if (this.action!= null) {
                if (that.action!= null) {
                    if (!leftAction.equals(rightAction)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.action!= null) {
                    return false;
                }
            }
        }
        {
            String leftSoapAction;
            leftSoapAction = this.getSoapAction();
            String rightSoapAction;
            rightSoapAction = that.getSoapAction();
            if (this.soapAction!= null) {
                if (that.soapAction!= null) {
                    if (!leftSoapAction.equals(rightSoapAction)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.soapAction!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            AttributedURIType theAction;
            theAction = this.getAction();
            if (this.action!= null) {
                currentHashCode += theAction.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theSoapAction;
            theSoapAction = this.getSoapAction();
            if (this.soapAction!= null) {
                currentHashCode += theSoapAction.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            AttributedURIType theAction;
            theAction = this.getAction();
            strategy.appendField(locator, this, "action", buffer, theAction, (this.action!= null));
        }
        {
            String theSoapAction;
            theSoapAction = this.getSoapAction();
            strategy.appendField(locator, this, "soapAction", buffer, theSoapAction, (this.soapAction!= null));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof ProblemActionType) {
            final ProblemActionType copy = ((ProblemActionType) draftCopy);
            {
                Boolean actionShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.action!= null));
                if (actionShouldBeCopiedAndSet == Boolean.TRUE) {
                    AttributedURIType sourceAction;
                    sourceAction = this.getAction();
                    AttributedURIType copyAction = ((AttributedURIType) strategy.copy(LocatorUtils.property(locator, "action", sourceAction), sourceAction, (this.action!= null)));
                    copy.setAction(copyAction);
                } else {
                    if (actionShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.action = null;
                    }
                }
            }
            {
                Boolean soapActionShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.soapAction!= null));
                if (soapActionShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceSoapAction;
                    sourceSoapAction = this.getSoapAction();
                    String copySoapAction = ((String) strategy.copy(LocatorUtils.property(locator, "soapAction", sourceSoapAction), sourceSoapAction, (this.soapAction!= null)));
                    copy.setSoapAction(copySoapAction);
                } else {
                    if (soapActionShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.soapAction = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new ProblemActionType();
    }

}
