
package org.somda.sdc.dpws.soap.wsdiscovery.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Java class for ScopesType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ScopesType">
 *   <simpleContent>
 *     <extension base="<http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01>UriListType">
 *       <attribute name="MatchBy" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *       <anyAttribute processContents='lax' namespace='##other'/>
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ScopesType", namespace = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01", propOrder = {
    "value"
})
public class ScopesType implements Cloneable, CopyTo, ToString
{

    @XmlValue
    protected List<String> value;
    @XmlAttribute(name = "MatchBy")
    @XmlSchemaType(name = "anyURI")
    protected String matchBy;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<>();

    /**
     * Gets the value of the value property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the value property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getValue().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the value property.
     */
    public List<String> getValue() {
        if (value == null) {
            value = new ArrayList<>();
        }
        return this.value;
    }

    /**
     * Gets the value of the matchBy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMatchBy() {
        return matchBy;
    }

    /**
     * Sets the value of the matchBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMatchBy(String value) {
        this.matchBy = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    public void setValue(List<String> value) {
        this.value = null;
        if (value!= null) {
            List<String> draftl = this.getValue();
            draftl.addAll(value);
        }
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ScopesType that = ((ScopesType) object);
        {
            List<String> leftValue;
            leftValue = (((this.value!= null)&&(!this.value.isEmpty()))?this.getValue():null);
            List<String> rightValue;
            rightValue = (((that.value!= null)&&(!that.value.isEmpty()))?that.getValue():null);
            if ((this.value!= null)&&(!this.value.isEmpty())) {
                if ((that.value!= null)&&(!that.value.isEmpty())) {
                    if (!leftValue.equals(rightValue)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.value!= null)&&(!that.value.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftMatchBy;
            leftMatchBy = this.getMatchBy();
            String rightMatchBy;
            rightMatchBy = that.getMatchBy();
            if (this.matchBy!= null) {
                if (that.matchBy!= null) {
                    if (!leftMatchBy.equals(rightMatchBy)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.matchBy!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theValue;
            theValue = (((this.value!= null)&&(!this.value.isEmpty()))?this.getValue():null);
            if ((this.value!= null)&&(!this.value.isEmpty())) {
                currentHashCode += theValue.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theMatchBy;
            theMatchBy = this.getMatchBy();
            if (this.matchBy!= null) {
                currentHashCode += theMatchBy.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            List<String> theValue;
            theValue = (((this.value!= null)&&(!this.value.isEmpty()))?this.getValue():null);
            strategy.appendField(locator, this, "value", buffer, theValue, ((this.value!= null)&&(!this.value.isEmpty())));
        }
        {
            String theMatchBy;
            theMatchBy = this.getMatchBy();
            strategy.appendField(locator, this, "matchBy", buffer, theMatchBy, (this.matchBy!= null));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof ScopesType) {
            final ScopesType copy = ((ScopesType) draftCopy);
            {
                Boolean valueShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, ((this.value!= null)&&(!this.value.isEmpty())));
                if (valueShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<String> sourceValue;
                    sourceValue = (((this.value!= null)&&(!this.value.isEmpty()))?this.getValue():null);
                    @SuppressWarnings("unchecked")
                    List<String> copyValue = ((List<String> ) strategy.copy(LocatorUtils.property(locator, "value", sourceValue), sourceValue, ((this.value!= null)&&(!this.value.isEmpty()))));
                    copy.setValue(copyValue);
                } else {
                    if (valueShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.value = null;
                    }
                }
            }
            {
                Boolean matchByShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.matchBy!= null));
                if (matchByShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceMatchBy;
                    sourceMatchBy = this.getMatchBy();
                    String copyMatchBy = ((String) strategy.copy(LocatorUtils.property(locator, "matchBy", sourceMatchBy), sourceMatchBy, (this.matchBy!= null)));
                    copy.setMatchBy(copyMatchBy);
                } else {
                    if (matchByShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.matchBy = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new ScopesType();
    }

}
