
package org.somda.sdc.dpws.soap.wsdiscovery.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;
import org.w3c.dom.Element;


/**
 * <p>Java class for SigType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SigType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <any processContents='lax' namespace='##other' maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="Scheme" use="required" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *       <attribute name="KeyId" type="{http://www.w3.org/2001/XMLSchema}base64Binary" />
 *       <attribute name="Refs" use="required" type="{http://www.w3.org/2001/XMLSchema}IDREFS" />
 *       <attribute name="Sig" use="required" type="{http://www.w3.org/2001/XMLSchema}base64Binary" />
 *       <anyAttribute processContents='lax' namespace='##other'/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SigType", namespace = "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01", propOrder = {
    "any"
})
public class SigType implements Cloneable, CopyTo, ToString
{

    @XmlAnyElement(lax = true)
    protected List<Object> any;
    @XmlAttribute(name = "Scheme", required = true)
    @XmlSchemaType(name = "anyURI")
    protected String scheme;
    @XmlAttribute(name = "KeyId")
    protected byte[] keyId;
    @XmlAttribute(name = "Refs", required = true)
    @XmlIDREF
    @XmlSchemaType(name = "IDREFS")
    protected List<Object> refs;
    @XmlAttribute(name = "Sig", required = true)
    protected byte[] sig;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<>();

    /**
     * Gets the value of the any property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the any property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAny().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * {@link Element }
     * </p>
     * 
     * 
     * @return
     *     The value of the any property.
     */
    public List<Object> getAny() {
        if (any == null) {
            any = new ArrayList<>();
        }
        return this.any;
    }

    /**
     * Gets the value of the scheme property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getScheme() {
        return scheme;
    }

    /**
     * Sets the value of the scheme property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setScheme(String value) {
        this.scheme = value;
    }

    /**
     * Gets the value of the keyId property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getKeyId() {
        return keyId;
    }

    /**
     * Sets the value of the keyId property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setKeyId(byte[] value) {
        this.keyId = value;
    }

    /**
     * Gets the value of the refs property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the refs property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRefs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * </p>
     * 
     * 
     * @return
     *     The value of the refs property.
     */
    public List<Object> getRefs() {
        if (refs == null) {
            refs = new ArrayList<>();
        }
        return this.refs;
    }

    /**
     * Gets the value of the sig property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getSig() {
        return sig;
    }

    /**
     * Sets the value of the sig property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setSig(byte[] value) {
        this.sig = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    public void setAny(List<Object> value) {
        this.any = null;
        if (value!= null) {
            List<Object> draftl = this.getAny();
            draftl.addAll(value);
        }
    }

    public void setRefs(List<Object> value) {
        this.refs = null;
        if (value!= null) {
            List<Object> draftl = this.getRefs();
            draftl.addAll(value);
        }
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final SigType that = ((SigType) object);
        {
            List<Object> leftAny;
            leftAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            List<Object> rightAny;
            rightAny = (((that.any!= null)&&(!that.any.isEmpty()))?that.getAny():null);
            if ((this.any!= null)&&(!this.any.isEmpty())) {
                if ((that.any!= null)&&(!that.any.isEmpty())) {
                    if (!leftAny.equals(rightAny)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.any!= null)&&(!that.any.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftScheme;
            leftScheme = this.getScheme();
            String rightScheme;
            rightScheme = that.getScheme();
            if (this.scheme!= null) {
                if (that.scheme!= null) {
                    if (!leftScheme.equals(rightScheme)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.scheme!= null) {
                    return false;
                }
            }
        }
        {
            byte[] leftKeyId;
            leftKeyId = this.getKeyId();
            byte[] rightKeyId;
            rightKeyId = that.getKeyId();
            if (this.keyId!= null) {
                if (that.keyId!= null) {
                    if (!Arrays.equals(leftKeyId, rightKeyId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.keyId!= null) {
                    return false;
                }
            }
        }
        {
            List<Object> leftRefs;
            leftRefs = ((refs!= null)?this.getRefs():null);
            List<Object> rightRefs;
            rightRefs = ((refs!= null)?that.getRefs():null);
            if (refs!= null) {
                if (refs!= null) {
                    if (!leftRefs.equals(rightRefs)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (refs!= null) {
                    return false;
                }
            }
        }
        {
            byte[] leftSig;
            leftSig = this.getSig();
            byte[] rightSig;
            rightSig = that.getSig();
            if (this.sig!= null) {
                if (that.sig!= null) {
                    if (!Arrays.equals(leftSig, rightSig)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.sig!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<Object> theAny;
            theAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            if ((this.any!= null)&&(!this.any.isEmpty())) {
                currentHashCode += theAny.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theScheme;
            theScheme = this.getScheme();
            if (this.scheme!= null) {
                currentHashCode += theScheme.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            byte[] theKeyId;
            theKeyId = this.getKeyId();
            currentHashCode += Arrays.hashCode(theKeyId);
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Object> theRefs;
            theRefs = ((refs!= null)?this.getRefs():null);
            if (refs!= null) {
                currentHashCode += theRefs.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            byte[] theSig;
            theSig = this.getSig();
            currentHashCode += Arrays.hashCode(theSig);
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            List<Object> theAny;
            theAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
            strategy.appendField(locator, this, "any", buffer, theAny, ((this.any!= null)&&(!this.any.isEmpty())));
        }
        {
            String theScheme;
            theScheme = this.getScheme();
            strategy.appendField(locator, this, "scheme", buffer, theScheme, (this.scheme!= null));
        }
        {
            byte[] theKeyId;
            theKeyId = this.getKeyId();
            strategy.appendField(locator, this, "keyId", buffer, theKeyId, (this.keyId!= null));
        }
        {
            List<Object> theRefs;
            theRefs = ((refs!= null)?this.getRefs():null);
            strategy.appendField(locator, this, "refs", buffer, theRefs, (refs!= null));
        }
        {
            byte[] theSig;
            theSig = this.getSig();
            strategy.appendField(locator, this, "sig", buffer, theSig, (this.sig!= null));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof SigType) {
            final SigType copy = ((SigType) draftCopy);
            {
                Boolean anyShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, ((this.any!= null)&&(!this.any.isEmpty())));
                if (anyShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<Object> sourceAny;
                    sourceAny = (((this.any!= null)&&(!this.any.isEmpty()))?this.getAny():null);
                    @SuppressWarnings("unchecked")
                    List<Object> copyAny = ((List<Object> ) strategy.copy(LocatorUtils.property(locator, "any", sourceAny), sourceAny, ((this.any!= null)&&(!this.any.isEmpty()))));
                    copy.setAny(copyAny);
                } else {
                    if (anyShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.any = null;
                    }
                }
            }
            {
                Boolean schemeShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.scheme!= null));
                if (schemeShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceScheme;
                    sourceScheme = this.getScheme();
                    String copyScheme = ((String) strategy.copy(LocatorUtils.property(locator, "scheme", sourceScheme), sourceScheme, (this.scheme!= null)));
                    copy.setScheme(copyScheme);
                } else {
                    if (schemeShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.scheme = null;
                    }
                }
            }
            {
                Boolean keyIdShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.keyId!= null));
                if (keyIdShouldBeCopiedAndSet == Boolean.TRUE) {
                    byte[] sourceKeyId;
                    sourceKeyId = this.getKeyId();
                    byte[] copyKeyId = ((byte[]) strategy.copy(LocatorUtils.property(locator, "keyId", sourceKeyId), sourceKeyId, (this.keyId!= null)));
                    copy.setKeyId(copyKeyId);
                } else {
                    if (keyIdShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.keyId = null;
                    }
                }
            }
            {
                Boolean refsShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (refs!= null));
                if (refsShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<Object> sourceRefs;
                    sourceRefs = ((refs!= null)?this.getRefs():null);
                    @SuppressWarnings("unchecked")
                    List<Object> copyRefs = ((List<Object> ) strategy.copy(LocatorUtils.property(locator, "refs", sourceRefs), sourceRefs, (refs!= null)));
                    copy.setRefs(copyRefs);
                } else {
                    if (refsShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.refs = null;
                    }
                }
            }
            {
                Boolean sigShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.sig!= null));
                if (sigShouldBeCopiedAndSet == Boolean.TRUE) {
                    byte[] sourceSig;
                    sourceSig = this.getSig();
                    byte[] copySig = ((byte[]) strategy.copy(LocatorUtils.property(locator, "sig", sourceSig), sourceSig, (this.sig!= null)));
                    copy.setSig(copySig);
                } else {
                    if (sigShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.sig = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new SigType();
    }

}
