
package org.somda.sdc.dpws.soap.wseventing.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlMixed;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.CopyStrategy;
import org.jvnet.jaxb.lang.CopyTo;
import org.jvnet.jaxb.lang.JAXBCopyStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;
import org.w3c.dom.Element;


/**
 * <p>Java class for FilterType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="FilterType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <any processContents='lax' namespace='##other' maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="Dialect" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *       <anyAttribute processContents='lax' namespace='##other'/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FilterType", namespace = "http://schemas.xmlsoap.org/ws/2004/08/eventing", propOrder = {
    "content"
})
public class FilterType implements Cloneable, CopyTo, ToString
{

    @XmlMixed
    @XmlAnyElement(lax = true)
    protected List<Object> content;
    @XmlAttribute(name = "Dialect")
    @XmlSchemaType(name = "anyURI")
    protected String dialect;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<>();

    /**
     * Gets the value of the content property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the content property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getContent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * {@link String }
     * {@link Element }
     * </p>
     * 
     * 
     * @return
     *     The value of the content property.
     */
    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<>();
        }
        return this.content;
    }

    /**
     * Gets the value of the dialect property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDialect() {
        return dialect;
    }

    /**
     * Sets the value of the dialect property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDialect(String value) {
        this.dialect = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    public void setContent(List<Object> value) {
        this.content = null;
        if (value!= null) {
            List<Object> draftl = this.getContent();
            draftl.addAll(value);
        }
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final FilterType that = ((FilterType) object);
        {
            List<Object> leftContent;
            leftContent = (((this.content!= null)&&(!this.content.isEmpty()))?this.getContent():null);
            List<Object> rightContent;
            rightContent = (((that.content!= null)&&(!that.content.isEmpty()))?that.getContent():null);
            if ((this.content!= null)&&(!this.content.isEmpty())) {
                if ((that.content!= null)&&(!that.content.isEmpty())) {
                    if (!leftContent.equals(rightContent)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.content!= null)&&(!that.content.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftDialect;
            leftDialect = this.getDialect();
            String rightDialect;
            rightDialect = that.getDialect();
            if (this.dialect!= null) {
                if (that.dialect!= null) {
                    if (!leftDialect.equals(rightDialect)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.dialect!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<Object> theContent;
            theContent = (((this.content!= null)&&(!this.content.isEmpty()))?this.getContent():null);
            if ((this.content!= null)&&(!this.content.isEmpty())) {
                currentHashCode += theContent.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDialect;
            theDialect = this.getDialect();
            if (this.dialect!= null) {
                currentHashCode += theDialect.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            List<Object> theContent;
            theContent = (((this.content!= null)&&(!this.content.isEmpty()))?this.getContent():null);
            strategy.appendField(locator, this, "content", buffer, theContent, ((this.content!= null)&&(!this.content.isEmpty())));
        }
        {
            String theDialect;
            theDialect = this.getDialect();
            strategy.appendField(locator, this, "dialect", buffer, theDialect, (this.dialect!= null));
        }
        return buffer;
    }

    @Override
    public Object clone() {
        return copyTo(createNewInstance());
    }

    @Override
    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.getInstance();
        return copyTo(null, target, strategy);
    }

    @Override
    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof FilterType) {
            final FilterType copy = ((FilterType) draftCopy);
            {
                Boolean contentShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, ((this.content!= null)&&(!this.content.isEmpty())));
                if (contentShouldBeCopiedAndSet == Boolean.TRUE) {
                    List<Object> sourceContent;
                    sourceContent = (((this.content!= null)&&(!this.content.isEmpty()))?this.getContent():null);
                    @SuppressWarnings("unchecked")
                    List<Object> copyContent = ((List<Object> ) strategy.copy(LocatorUtils.property(locator, "content", sourceContent), sourceContent, ((this.content!= null)&&(!this.content.isEmpty()))));
                    copy.setContent(copyContent);
                } else {
                    if (contentShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.content = null;
                    }
                }
            }
            {
                Boolean dialectShouldBeCopiedAndSet = strategy.shouldBeCopiedAndSet(locator, (this.dialect!= null));
                if (dialectShouldBeCopiedAndSet == Boolean.TRUE) {
                    String sourceDialect;
                    sourceDialect = this.getDialect();
                    String copyDialect = ((String) strategy.copy(LocatorUtils.property(locator, "dialect", sourceDialect), sourceDialect, (this.dialect!= null)));
                    copy.setDialect(copyDialect);
                } else {
                    if (dialectShouldBeCopiedAndSet == Boolean.FALSE) {
                        copy.dialect = null;
                    }
                }
            }
        }
        return draftCopy;
    }

    @Override
    public Object createNewInstance() {
        return new FilterType();
    }

}
