/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.jupiter.api.Assertions;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.soap.CommunicationContext;

public class MemoryCommunicationLog
implements CommunicationLog {
    private final ArrayList<Message> messages = new ArrayList();

    public OutputStream logMessage(CommunicationLog.Direction direction, CommunicationLog.TransportType transportType, CommunicationLog.MessageType messagePatternType, CommunicationContext communicationContext, OutputStream message) {
        Message messageType = new Message(direction, transportType, messagePatternType, communicationContext);
        this.messages.add(messageType);
        return new TeeOutputStream(message, (OutputStream)messageType);
    }

    public OutputStream logMessage(CommunicationLog.Direction direction, CommunicationLog.TransportType transportType, CommunicationLog.MessageType messagePatternType, CommunicationContext communicationContext) {
        Message messageType = new Message(direction, transportType, messagePatternType, communicationContext);
        this.messages.add(messageType);
        return messageType;
    }

    public InputStream logMessage(CommunicationLog.Direction direction, CommunicationLog.TransportType transportType, CommunicationLog.MessageType messageType, CommunicationContext communicationContext, InputStream message) {
        try {
            byte[] bytes = ByteStreams.toByteArray((InputStream)message);
            try (Message targetStream = new Message(direction, transportType, messageType, communicationContext);){
                this.messages.add(targetStream);
                new ByteArrayInputStream(bytes).transferTo(targetStream);
            }
            return new ByteArrayInputStream(bytes);
        }
        catch (IOException e) {
            Assertions.fail((Throwable)e);
            return message;
        }
    }

    public List<Message> getMessages() {
        return new ArrayList<Message>(this.messages);
    }

    public class Message
    extends OutputStream {
        private final CommunicationLog.Direction direction;
        private final CommunicationLog.TransportType transportType;
        private final CommunicationContext communicationContext;
        private final ByteArrayOutputStream outputStream;

        Message(CommunicationLog.Direction direction, CommunicationLog.TransportType transportType, CommunicationLog.MessageType messageType, CommunicationContext communicationContext) {
            this.direction = direction;
            this.transportType = transportType;
            this.communicationContext = communicationContext;
            this.outputStream = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }

        public String getMessage() {
            return new String(this.outputStream.toByteArray(), StandardCharsets.UTF_8);
        }

        public CommunicationLog.Direction getDirection() {
            return this.direction;
        }
    }
}

