/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.udp.UdpBindingService;
import org.somda.sdc.dpws.udp.UdpMessage;
import org.somda.sdc.dpws.udp.UdpMessageReceiverCallback;

public class UdpBindingServiceMock
extends AbstractIdleService
implements UdpBindingService {
    private static final Logger LOG = LogManager.getLogger(UdpBindingServiceMock.class);
    private static final int MIN_PORT = 49152;
    private static final int MAX_PORT = 65535;
    private static final Random RANDOM = new Random();
    private static final Set<Integer> ACTIVE_PORTS = new HashSet<Integer>();
    private static final EventBus UDP_BUS = new AsyncEventBus((Executor)Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setNameFormat("UDP_BUS-thread-%d").setDaemon(true).build()));
    private final String selfAddress;
    private final Integer selfPort = this.assignRandomPort();
    private final String multicastAddress;
    private final Integer multicastPort;
    private UdpMessageReceiverCallback udpMessageReceiver;

    @AssistedInject
    UdpBindingServiceMock(@Assisted NetworkInterface networkInterface, @Assisted @Nullable InetAddress multicastGroup, @Assisted(value="multicastPort") @Nullable Integer multicastPort, @Assisted(value="maxMessageSize") Integer maxMessageSize) {
        this.selfAddress = "0.0.0.0";
        if (multicastGroup != null && multicastPort != null) {
            this.multicastAddress = multicastGroup.getHostAddress();
            this.multicastPort = multicastPort;
        } else {
            this.multicastAddress = null;
            this.multicastPort = null;
        }
    }

    public void setMessageReceiver(UdpMessageReceiverCallback receiver) {
        this.udpMessageReceiver = receiver;
    }

    public void sendMessage(UdpMessage message) {
        if (!message.hasTransportData()) {
            CommunicationContext ctxt = new CommunicationContext(new ApplicationInfo(), new TransportInfo("soap.udp", null, null, this.multicastAddress, this.multicastPort, Collections.emptyList()));
            message = new UdpMessage(message.getData(), message.getLength(), ctxt);
        }
        LOG.debug("Posting message from {}:{} to {}:{}", (Object)this.selfAddress, (Object)this.selfPort, (Object)message.getHost(), (Object)message.getPort());
        LOG.trace("Send outgoing UDP message: {}", (Object)message);
        UDP_BUS.post((Object)new UdpEvent(message, this.selfAddress, this.selfPort));
    }

    public String toString() {
        String multicast = "w/o multicast";
        if (this.multicastAddress != null) {
            multicast = String.format("w/ multicast joined at %s:%s", this.multicastAddress, this.multicastPort);
        }
        return String.format("[%s:%s %s]", this.selfAddress, this.selfPort, multicast);
    }

    protected void startUp() {
        UDP_BUS.register((Object)this);
        LOG.info("UDP message queue for binding is running: {}", (Object)this);
    }

    protected void shutDown() {
        UDP_BUS.unregister((Object)this);
        LOG.info("UDP message queue for binding shut down: {}", (Object)this);
    }

    private Integer assignRandomPort() {
        Integer random;
        while (ACTIVE_PORTS.contains(random = Integer.valueOf(RANDOM.nextInt(16384) + 49152))) {
        }
        ACTIVE_PORTS.add(random);
        return random;
    }

    @Subscribe
    private void receiveUdpMessage(UdpEvent udpMessage) {
        boolean isReceiverMyMulticast;
        LOG.debug("Received message from sender {}:{} on receiver {}:{}", (Object)udpMessage.getSenderAddress(), (Object)udpMessage.getSenderPort(), (Object)this.selfAddress, (Object)this.selfPort);
        boolean isReceiverSelf = udpMessage.getMessage().getHost().equals(this.selfAddress) && udpMessage.getMessage().getPort().equals(this.selfPort);
        boolean bl = isReceiverMyMulticast = udpMessage.getMessage().getHost().equals(this.multicastAddress) && udpMessage.getMessage().getPort().equals(this.multicastPort);
        if (isReceiverSelf || isReceiverMyMulticast) {
            CommunicationContext ctxt = new CommunicationContext(new ApplicationInfo(), new TransportInfo("soap.udp", null, null, udpMessage.getSenderAddress(), udpMessage.getSenderPort(), Collections.emptyList()));
            UdpMessage message = new UdpMessage(udpMessage.getMessage().getData(), udpMessage.getMessage().getLength(), ctxt);
            LOG.debug("Incoming UDP message from sender {}:{} was directed at me", (Object)udpMessage.getSenderAddress(), (Object)udpMessage.getSenderPort());
            LOG.trace("Received incoming UDP message: {}", (Object)message);
            this.udpMessageReceiver.receive(message);
        } else {
            LOG.debug("Incoming UDP message from sender {}:{} was not directed at me", (Object)udpMessage.getSenderAddress(), (Object)udpMessage.getSenderPort());
        }
    }

    private class UdpEvent {
        private final UdpMessage message;
        private final String senderAddress;
        private final Integer senderPort;

        UdpEvent(UdpMessage message, String senderAddress, Integer senderPort) {
            this.message = message;
            this.senderAddress = senderAddress;
            this.senderPort = senderPort;
        }

        public UdpMessage getMessage() {
            return this.message;
        }

        public String getSenderAddress() {
            return this.senderAddress;
        }

        public Integer getSenderPort() {
            return this.senderPort;
        }
    }
}

