/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.http.jetty;

import com.google.inject.AbstractModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.jetty.server.Server;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.TransportBindingException;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.http.HttpException;
import org.somda.sdc.dpws.http.HttpHandler;
import org.somda.sdc.dpws.http.jetty.JettyHttpServerRegistry;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;

class JettyHttpServerRegistryIT
extends DpwsTest {
    private static final int COMPRESSION_MIN_SIZE = 32;
    private JettyHttpServerRegistry httpServerRegistry;
    private TransportBindingFactory transportBindingFactory;
    private SoapMessageFactory soapMessageFactory;
    private EnvelopeFactory envelopeFactory;

    JettyHttpServerRegistryIT() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        DefaultDpwsConfigModule override = new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("Dpws.GzipCompression", Boolean.class, true);
                this.bind("Dpws.GzipCompressionMinSize", Integer.class, 32);
            }
        };
        this.overrideBindings((AbstractModule)override);
        super.setUp();
        this.httpServerRegistry = (JettyHttpServerRegistry)this.getInjector().getInstance(JettyHttpServerRegistry.class);
        this.transportBindingFactory = (TransportBindingFactory)this.getInjector().getInstance(TransportBindingFactory.class);
        this.soapMessageFactory = (SoapMessageFactory)this.getInjector().getInstance(SoapMessageFactory.class);
        this.envelopeFactory = (EnvelopeFactory)this.getInjector().getInstance(EnvelopeFactory.class);
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).startAsync().awaitRunning();
    }

    @Test
    void registerContext() throws Exception {
        String baseUri = "http://127.0.0.1:0";
        String ctxtPath = "/test/mulitple/path/segments";
        final AtomicBoolean isRequested = new AtomicBoolean(false);
        this.httpServerRegistry.startAsync().awaitRunning();
        String srvUri = this.httpServerRegistry.registerContext(baseUri, "/test/mulitple/path/segments", new HttpHandler(){

            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) throws HttpException {
                isRequested.set(true);
            }
        });
        TransportBinding httpBinding = this.transportBindingFactory.createHttpBinding(srvUri);
        httpBinding.onRequestResponse(this.createASoapMessage());
        MatcherAssert.assertThat((Object)isRequested.get(), (Matcher)CoreMatchers.is((Object)true));
        this.httpServerRegistry.stopAsync().awaitTerminated();
    }

    @Test
    void unregisterContext() throws Exception {
        String ctxtPath = "/test";
        String baseUri = "http://127.0.0.1:0";
        final AtomicBoolean isRequested = new AtomicBoolean(false);
        this.httpServerRegistry.startAsync().awaitRunning();
        String srvUri = this.httpServerRegistry.registerContext(baseUri, ctxtPath, new HttpHandler(){

            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) throws HttpException {
                isRequested.set(true);
            }
        });
        TransportBinding httpBinding = this.transportBindingFactory.createHttpBinding(srvUri);
        httpBinding.onNotification(this.createASoapMessage());
        MatcherAssert.assertThat((Object)isRequested.get(), (Matcher)CoreMatchers.is((Object)true));
        isRequested.set(false);
        this.httpServerRegistry.unregisterContext(srvUri, ctxtPath);
        try {
            httpBinding.onNotification(this.createASoapMessage());
            Assertions.fail();
        }
        catch (TransportBindingException transportBindingException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)isRequested.get(), (Matcher)CoreMatchers.is((Object)false));
        this.httpServerRegistry.stopAsync().awaitTerminated();
    }

    @Test
    void registerMultipleContextsOnOneServer() throws MarshallingException, TransportException {
        String baseUri = "http://127.0.0.1:0";
        String ctxtPath1 = "/ctxt/path1";
        String ctxtPath2 = "/ctxt/path2";
        final AtomicBoolean isPath1Requested = new AtomicBoolean(false);
        final AtomicBoolean isPath2Requested = new AtomicBoolean(false);
        this.httpServerRegistry.startAsync().awaitRunning();
        URI srvUri1 = URI.create(this.httpServerRegistry.registerContext(baseUri, ctxtPath1, new HttpHandler(){

            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) throws HttpException {
                isPath1Requested.set(true);
            }
        }));
        baseUri = String.format("%s:%s", srvUri1.getScheme(), srvUri1.getSchemeSpecificPart());
        String srvUri2 = this.httpServerRegistry.registerContext(baseUri, ctxtPath2, new HttpHandler(){

            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) throws HttpException {
                isPath2Requested.set(true);
            }
        });
        TransportBinding httpBinding1 = this.transportBindingFactory.createHttpBinding(srvUri1.toString());
        TransportBinding httpBinding2 = this.transportBindingFactory.createHttpBinding(srvUri2);
        httpBinding1.onNotification(this.createASoapMessage());
        httpBinding2.onNotification(this.createASoapMessage());
        MatcherAssert.assertThat((Object)isPath1Requested.get(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)isPath2Requested.get(), (Matcher)CoreMatchers.is((Object)true));
        this.httpServerRegistry.unregisterContext(srvUri1.toString(), srvUri1.getPath());
        isPath1Requested.set(false);
        try {
            httpBinding1.onNotification(this.createASoapMessage());
            Assertions.fail();
        }
        catch (TransportBindingException transportBindingException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)isPath1Requested.get(), (Matcher)CoreMatchers.is((Object)false));
        isPath2Requested.set(false);
        Assertions.assertFalse((boolean)isPath2Requested.get());
        try {
            httpBinding2.onRequestResponse(this.createASoapMessage());
        }
        catch (SoapFaultException e) {
            Assertions.fail((Throwable)e);
        }
        Assertions.assertTrue((boolean)isPath2Requested.get());
        this.httpServerRegistry.stopAsync().awaitTerminated();
    }

    @Test
    void registerMultipleServers() {
        String localhostUri = "http://127.0.0.1:0";
        URI firstServer = URI.create(this.httpServerRegistry.initHttpServer(localhostUri));
        URI secondServer = URI.create(this.httpServerRegistry.initHttpServer(localhostUri));
        MatcherAssert.assertThat((Object)firstServer.getPort(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)secondServer.getPort())));
    }

    @Test
    void defaultPort() throws Exception {
        Server httpServer = new Server(new InetSocketAddress("127.0.0.1", 0));
        httpServer.start();
        Assertions.assertTrue((boolean)httpServer.isStarted());
        Assertions.assertEquals((int)1, (int)httpServer.getConnectors().length);
        MatcherAssert.assertThat((Object)httpServer.getURI().getPort(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0)));
        httpServer.stop();
    }

    @Test
    void gzipCompression() throws IOException {
        byte[] decompressedResponseBytes;
        String baseUri = "http://127.0.0.1:0";
        String compressedPath = "/ctxt/path1";
        String expectedString = "The quick brown fox jumps over the lazy dog";
        final StringBuilder expectedResponseBuilder = new StringBuilder("ABCEDFG12345");
        while (expectedResponseBuilder.toString().getBytes().length < 32) {
            expectedResponseBuilder.append("a");
        }
        final AtomicReference resultString = new AtomicReference();
        this.httpServerRegistry.startAsync().awaitRunning();
        String srvUri1 = this.httpServerRegistry.registerContext(baseUri, "/ctxt/path1", new HttpHandler(){

            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) throws HttpException {
                try {
                    byte[] bytes = inStream.readAllBytes();
                    resultString.set(new String(bytes));
                    outStream.write(expectedResponseBuilder.toString().getBytes());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        CloseableHttpClient client = HttpClients.custom().disableContentCompression().build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
            gzos.write("The quick brown fox jumps over the lazy dog".getBytes(StandardCharsets.UTF_8));
        }
        byte[] requestContent = baos.toByteArray();
        Assertions.assertNotEquals((Object)"The quick brown fox jumps over the lazy dog".getBytes(), (Object)requestContent);
        HttpPost post = new HttpPost(srvUri1);
        post.setHeader("Accept-Encoding", "gzip");
        post.setHeader("Content-Encoding", "gzip");
        ByteArrayEntity requestEntity = new ByteArrayEntity(requestContent);
        post.setEntity((HttpEntity)requestEntity);
        HttpResponse response = client.execute((HttpUriRequest)post);
        byte[] responseBytes = response.getEntity().getContent().readAllBytes();
        Assertions.assertNotEquals((Object)expectedResponseBuilder.toString().getBytes(), (Object)responseBytes);
        ByteArrayInputStream responseBais = new ByteArrayInputStream(responseBytes);
        try (GZIPInputStream gzos = new GZIPInputStream(responseBais);){
            decompressedResponseBytes = gzos.readAllBytes();
        }
        Assertions.assertEquals((Object)expectedResponseBuilder.toString(), (Object)new String(decompressedResponseBytes));
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", resultString.get());
    }

    private SoapMessage createASoapMessage() {
        return this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope());
    }
}

