/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.inject.AbstractModule;
import it.org.somda.sdc.dpws.IntegrationTestPeer;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.client.Client;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;

public class ClientPeer
extends IntegrationTestPeer {
    private final Client client;
    private final DpwsFramework dpwsFramework;

    public ClientPeer(DefaultDpwsConfigModule configModule) {
        this(configModule, null);
    }

    public ClientPeer(DefaultDpwsConfigModule configModule, AbstractModule ... overridingModule) {
        this.setupInjector(configModule, overridingModule);
        this.dpwsFramework = (DpwsFramework)this.getInjector().getInstance(DpwsFramework.class);
        this.client = (Client)this.getInjector().getInstance(Client.class);
    }

    public Client getClient() {
        if (!this.isRunning()) {
            throw new RuntimeException("ClientPeer is not running");
        }
        return this.client;
    }

    protected void startUp() {
        this.dpwsFramework.startAsync().awaitRunning();
        this.client.startAsync().awaitRunning();
    }

    protected void shutDown() {
        this.client.stopAsync().awaitTerminated();
        this.dpwsFramework.stopAsync().awaitTerminated();
    }
}

