/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import dpws_test_service.messages._2017._05._10.ObjectFactory;
import dpws_test_service.messages._2017._05._10.TestNotification;
import dpws_test_service.messages._2017._05._10.TestOperationRequest;
import dpws_test_service.messages._2017._05._10.TestOperationResponse;
import it.org.somda.sdc.dpws.IntegrationTestUtil;
import it.org.somda.sdc.dpws.MockedUdpBindingModule;
import it.org.somda.sdc.dpws.soap.BasicPopulatedDevice;
import it.org.somda.sdc.dpws.soap.ClientPeer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import test.org.somda.common.LoggingTestWatcher;

@ExtendWith(value={LoggingTestWatcher.class})
class InvocationIT {
    private static final Duration MAX_WAIT_TIME = IntegrationTestUtil.MAX_WAIT_TIME;
    private final IntegrationTestUtil IT = new IntegrationTestUtil();
    private BasicPopulatedDevice devicePeer;
    private ClientPeer clientPeer;
    private HostingServiceProxy hostingServiceProxy;
    private ObjectFactory factory;
    private final SoapUtil soapUtil = (SoapUtil)this.IT.getInjector().getInstance(SoapUtil.class);

    public InvocationIT() {
        IntegrationTestUtil.preferIpV4Usage();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.factory = new ObjectFactory();
        this.devicePeer = new BasicPopulatedDevice(new MockedUdpBindingModule());
        this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
            }
        }, new MockedUdpBindingModule());
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        this.hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
    }

    @AfterEach
    public void tearDown() {
        this.devicePeer.stopAsync().awaitTerminated();
        this.clientPeer.stopAsync().awaitTerminated();
        this.devicePeer = null;
        this.clientPeer = null;
    }

    @Test
    void requestResponse() throws Exception {
        int i;
        int COUNT = 100;
        HostedServiceProxy srv1 = (HostedServiceProxy)this.hostingServiceProxy.getHostedServices().get("TestService1");
        Assertions.assertNotNull((Object)srv1);
        String testString = "test";
        Integer testInt = 10;
        String expectedString = new StringBuilder("test").reverse().toString();
        Integer expectedInt = testInt * 2;
        TestOperationRequest request = this.factory.createTestOperationRequest();
        request.setParam1("test");
        request.setParam2(testInt.intValue());
        for (int i2 = 0; i2 < 100; ++i2) {
            SoapMessage reqMsg = this.soapUtil.createMessage("http://dpws-test-service/2017/05/10/TestPortType1/TestOperationRequest", (Object)request);
            SoapMessage resMsg = srv1.sendRequestResponse(reqMsg);
            Optional resBody = this.soapUtil.getBody(resMsg, TestOperationResponse.class);
            Assertions.assertTrue((boolean)resBody.isPresent());
            TestOperationResponse testOperationResponse = (TestOperationResponse)resBody.get();
            Assertions.assertEquals((Object)expectedString, (Object)testOperationResponse.getResult1());
            Assertions.assertEquals((int)expectedInt, (int)testOperationResponse.getResult2());
        }
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        ListeningExecutorService les = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(100));
        for (i = 0; i < 100; ++i) {
            ListenableFuture future = les.submit(() -> {
                SoapMessage reqMsg = this.soapUtil.createMessage("http://dpws-test-service/2017/05/10/TestPortType1/TestOperationRequest", (Object)request);
                SoapMessage resMsg = srv1.sendRequestResponse(reqMsg);
                Optional resBody = this.soapUtil.getBody(resMsg, TestOperationResponse.class);
                Assertions.assertTrue((boolean)resBody.isPresent());
                TestOperationResponse testOperationResponse = (TestOperationResponse)resBody.get();
                Assertions.assertEquals((Object)expectedString, (Object)testOperationResponse.getResult1());
                Assertions.assertEquals((int)expectedInt, (int)testOperationResponse.getResult2());
                return true;
            });
            futures.add(future);
        }
        for (i = 0; i < 100; ++i) {
            ((ListenableFuture)futures.get(i)).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        }
    }

    @Test
    void notification() throws Exception {
        int COUNT = 100;
        final SettableFuture notificationFuture = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)this.hostingServiceProxy.getHostedServices().get("TestService1");
        ListenableFuture subscribe = srv1.getEventSinkAccess().subscribe(Collections.singletonList("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification"), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor
            void onNotification(NotificationObject message) {
                this.receivedNotifications.add((TestNotification)InvocationIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).orElseThrow(() -> new RuntimeException("TestNotification could not be converted")));
                if (this.receivedNotifications.size() == 100) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }
        });
        subscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        for (int i = 0; i < 100; ++i) {
            TestNotification testNotification = this.factory.createTestNotification();
            testNotification.setParam1(Integer.toString(i));
            testNotification.setParam2(i);
            this.devicePeer.getService1().sendNotification(testNotification);
        }
        List notifications = (List)notificationFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((int)100, (int)notifications.size());
        for (int i = 0; i < 100; ++i) {
            TestNotification notification = (TestNotification)notifications.get(i);
            Assertions.assertEquals((Object)Integer.toString(i), (Object)notification.getParam1());
            Assertions.assertEquals((int)i, (int)notification.getParam2());
        }
    }

    @Test
    void notificationWithMultipleSubscriptions() throws Exception {
        int COUNT = 100;
        final SettableFuture notificationFuture1 = SettableFuture.create();
        final SettableFuture notificationFuture2 = SettableFuture.create();
        final SettableFuture notificationFuture3 = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)this.hostingServiceProxy.getHostedServices().get("TestService1");
        HostedServiceProxy srv2 = (HostedServiceProxy)this.hostingServiceProxy.getHostedServices().get("TestService2");
        ListenableFuture subscribe1 = srv1.getEventSinkAccess().subscribe(Collections.singletonList("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification"), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification(NotificationObject message) {
                this.receivedNotifications.add((TestNotification)InvocationIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).orElseThrow(() -> new RuntimeException("TestNotification could not be converted")));
                if (this.receivedNotifications.size() == 100) {
                    notificationFuture1.set(this.receivedNotifications);
                }
            }
        });
        ListenableFuture subscribe2 = srv1.getEventSinkAccess().subscribe(Collections.singletonList("http://dpws-test-service/2017/05/10/TestPortType2/TestNotification"), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType2/TestNotification")
            void onNotification(NotificationObject message) {
                this.receivedNotifications.add((TestNotification)InvocationIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).orElseThrow(() -> new RuntimeException("TestNotification could not be converted")));
                if (this.receivedNotifications.size() == 100) {
                    notificationFuture2.set(this.receivedNotifications);
                }
            }
        });
        ListenableFuture subscribe3 = srv2.getEventSinkAccess().subscribe(Collections.singletonList("http://dpws-test-service/2017/05/10/TestPortType3/TestNotification"), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType3/TestNotification")
            void onNotification(NotificationObject message) {
                this.receivedNotifications.add((TestNotification)InvocationIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).orElseThrow(() -> new RuntimeException("TestNotification could not be converted")));
                if (this.receivedNotifications.size() == 100) {
                    notificationFuture3.set(this.receivedNotifications);
                }
            }
        });
        subscribe1.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        subscribe2.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        subscribe3.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        for (int i = 0; i < 100; ++i) {
            TestNotification testNotification = this.factory.createTestNotification();
            testNotification.setParam1(Integer.toString(i));
            testNotification.setParam2(i);
            this.devicePeer.getService1().sendNotification(testNotification);
            this.devicePeer.getService2().sendNotification(testNotification);
        }
        List notifications1 = (List)notificationFuture1.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        List notifications2 = (List)notificationFuture2.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        List notifications3 = (List)notificationFuture3.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((int)100, (int)notifications1.size());
        Assertions.assertEquals((int)100, (int)notifications2.size());
        Assertions.assertEquals((int)100, (int)notifications3.size());
        for (int i = 0; i < 100; ++i) {
            TestNotification notification1 = (TestNotification)notifications1.get(i);
            Assertions.assertEquals((Object)Integer.toString(i), (Object)notification1.getParam1());
            Assertions.assertEquals((int)i, (int)notification1.getParam2());
            TestNotification notification2 = (TestNotification)notifications2.get(i);
            Assertions.assertEquals((Object)Integer.toString(i), (Object)notification2.getParam1());
            Assertions.assertEquals((int)i, (int)notification2.getParam2());
            TestNotification notification3 = (TestNotification)notifications3.get(i);
            Assertions.assertEquals((Object)Integer.toString(i), (Object)notification3.getParam1());
            Assertions.assertEquals((int)i, (int)notification3.getParam2());
        }
    }

    @Test
    void notificationSubscribeMultipleActions() throws Exception {
        int COUNT = 100;
        final SettableFuture notificationFuture = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)this.hostingServiceProxy.getHostedServices().get("TestService1");
        ListenableFuture subscribe = srv1.getEventSinkAccess().subscribe(Arrays.asList("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification", "http://dpws-test-service/2017/05/10/TestPortType2/TestNotification"), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification1(NotificationObject message) {
                this.onNotification(message);
            }

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType2/TestNotification")
            void onNotification2(NotificationObject message) {
                this.onNotification(message);
            }

            private void onNotification(NotificationObject message) {
                this.receivedNotifications.add((TestNotification)InvocationIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).orElseThrow(() -> new RuntimeException("TestNotification could not be converted")));
                if (this.receivedNotifications.size() == 200) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }
        });
        subscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        for (int i = 0; i < 100; ++i) {
            TestNotification testNotification = this.factory.createTestNotification();
            testNotification.setParam1(Integer.toString(i));
            testNotification.setParam2(i);
            this.devicePeer.getService1().sendNotification(testNotification);
        }
        List notifications = (List)notificationFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((int)200, (int)notifications.size());
        for (int i = 0; i < 100; ++i) {
            TestNotification notificationEven = (TestNotification)notifications.get(i * 2);
            Assertions.assertEquals((Object)Integer.toString(i), (Object)notificationEven.getParam1());
            Assertions.assertEquals((int)i, (int)notificationEven.getParam2());
            TestNotification notificationOdd = (TestNotification)notifications.get(i * 2 + 1);
            Assertions.assertEquals((Object)Integer.toString(i), (Object)notificationOdd.getParam1());
            Assertions.assertEquals((int)i, (int)notificationOdd.getParam2());
        }
    }
}

