/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.AbstractModule;
import dpws_test_service.messages._2017._05._10.TestNotification;
import it.org.somda.sdc.dpws.IntegrationTestUtil;
import it.org.somda.sdc.dpws.MockedUdpBindingModule;
import it.org.somda.sdc.dpws.soap.BasicPopulatedDevice;
import it.org.somda.sdc.dpws.soap.ClientPeer;
import it.org.somda.sdc.dpws.soap.Ssl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import jregex.Matcher;
import jregex.Pattern;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogImpl;
import org.somda.sdc.dpws.CommunicationLogSink;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;
import org.somda.sdc.dpws.soap.MarshallingService;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.interception.RequestResponseCallback;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wseventing.SubscribeResult;
import org.somda.sdc.dpws.soap.wseventing.SubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.model.GetStatusResponse;
import org.somda.sdc.dpws.soap.wseventing.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wseventing.model.Renew;
import org.somda.sdc.dpws.soap.wseventing.model.RenewResponse;
import test.org.somda.common.LoggingTestWatcher;

@ExtendWith(value={LoggingTestWatcher.class})
class SubscriptionIT {
    private static final Duration MAX_WAIT_TIME = Duration.ofMinutes(3L);
    private static final Pattern URI_PATTERN = new Pattern("(({absoluteUri}({scheme}(?i:[a-z][a-z0-9+-.]*)):((((//(((((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;:&=+$,])*)@)?((((([a-zA-Z0-9]|([a-zA-Z0-9]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.)*([a-zA-Z]|([a-zA-Z]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))(\\.)?)|([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+))(:([0-9]*))?))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[$,;:@&=+])+)))((/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))?)|(/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))(\\?({absoluteUriQuery}(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9]))*)))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;?:@&=+$,])(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])))*)))|({relativeUri}((//(((((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;:&=+$,])*)@)?((((([a-zA-Z0-9]|([a-zA-Z0-9]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.)*([a-zA-Z]|([a-zA-Z]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))(\\.)?)|([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+))(:([0-9]*))?))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[$,;:@&=+])+)))((/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))?)|(/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*)))|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;@&=+$,])+((/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))?))(\\?({relativeUriQuery}(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9]))*)))?))?(#({fragment}(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9]))*)))?");
    private static final Pattern AUTHORITY_PATTERN = new Pattern("((((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;:&=+$,])*)@)?((((([a-zA-Z0-9]|([a-zA-Z0-9]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.)*([a-zA-Z]|([a-zA-Z]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))(\\.)?)|([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+))(:([0-9]*))?))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[$,;:@&=+])+))");
    private static final Pattern ABS_PATH_PATTERN = new Pattern("(/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*)))");
    private final IntegrationTestUtil IT = new IntegrationTestUtil();
    private final SoapUtil soapUtil = (SoapUtil)this.IT.getInjector().getInstance(SoapUtil.class);
    private final WsAddressingUtil wsaUtil = (WsAddressingUtil)this.IT.getInjector().getInstance(WsAddressingUtil.class);
    private BasicPopulatedDevice devicePeer;
    private ClientPeer clientPeer;
    private HostnameVerifier verifier;
    private TestCommLogSink logSink;
    private MarshallingService marshallingService;
    private TransportBindingFactory transportBindingFactory;
    private RequestResponseClientFactory requestResponseClientFactory;
    private ObjectFactory wseFactory;

    SubscriptionIT() {
        IntegrationTestUtil.preferIpV4Usage();
    }

    @BeforeEach
    void setUp() {
        final CryptoSettings serverCryptoSettings = Ssl.setupServer();
        this.verifier = (HostnameVerifier)Mockito.mock(HostnameVerifier.class);
        Mockito.when((Object)this.verifier.verify(ArgumentMatchers.anyString(), (SSLSession)ArgumentMatchers.any())).thenReturn((Object)true);
        this.devicePeer = new BasicPopulatedDevice(new DeviceSettings(){
            final EndpointReferenceType epr;
            {
                this.epr = SubscriptionIT.this.wsaUtil.createEprWithAddress(SubscriptionIT.this.soapUtil.createUriFromUuid(UUID.randomUUID()));
            }

            public EndpointReferenceType getEndpointReference() {
                return this.epr;
            }

            public NetworkInterface getNetworkInterface() {
                try {
                    return NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, serverCryptoSettings);
                this.bind("Dpws.EnableHttp", Boolean.class, false);
                this.bind("Dpws.EnableHttps", Boolean.class, true);
                this.bind("Dpws.Crypto.DeviceHostnameVerifier", HostnameVerifier.class, SubscriptionIT.this.verifier);
                this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.3"});
                this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_128_GCM_SHA256"});
            }
        }, new MockedUdpBindingModule());
        final CryptoSettings clientCryptoSettings = Ssl.setupClient();
        AbstractModule override = new AbstractModule(){

            protected void configure() {
                this.bind(CommunicationLogSink.class).to(TestCommLogSink.class).asEagerSingleton();
                this.bind(CommunicationLog.class).to(CommunicationLogImpl.class).asEagerSingleton();
            }
        };
        try {
            this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

                public void customConfigure() {
                    this.bind("WsDiscovery.MaxWaitForProbeMatches", Duration.class, Duration.ofSeconds(MAX_WAIT_TIME.getSeconds() / 2L));
                    this.bind("Dpws.Crypto.Settings", CryptoSettings.class, clientCryptoSettings);
                    this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
                    this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.3"});
                    this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_128_GCM_SHA256"});
                    this.bind("Dpws.EnableHttp", Boolean.class, false);
                    this.bind("Dpws.EnableHttps", Boolean.class, true);
                }
            }, new MockedUdpBindingModule(), override);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.transportBindingFactory = (TransportBindingFactory)this.clientPeer.getInjector().getInstance(TransportBindingFactory.class);
        this.requestResponseClientFactory = (RequestResponseClientFactory)this.clientPeer.getInjector().getInstance(RequestResponseClientFactory.class);
        this.wseFactory = (ObjectFactory)this.clientPeer.getInjector().getInstance(ObjectFactory.class);
        this.marshallingService = (MarshallingService)this.clientPeer.getInjector().getInstance(MarshallingService.class);
        this.logSink = (TestCommLogSink)this.clientPeer.getInjector().getInstance(CommunicationLogSink.class);
    }

    @AfterEach
    void tearDown() {
        this.logSink.clear();
        this.devicePeer.stopAsync().awaitTerminated();
        this.clientPeer.stopAsync().awaitTerminated();
    }

    @Test
    void testSubscriptionProviderSubscriptionManagerEndpoint() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        final int COUNT = 100;
        final SettableFuture notificationFuture = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        ListenableFuture subscribe = srv1.getEventSinkAccess().subscribe(Collections.singletonList("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification"), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification(NotificationObject message) {
                Assertions.assertTrue((boolean)message.getCommunicationContext().isPresent());
                Assertions.assertFalse((boolean)((CommunicationContext)message.getCommunicationContext().get()).getTransportInfo().getX509Certificates().isEmpty());
                this.receivedNotifications.add((TestNotification)SubscriptionIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).orElseThrow(() -> new RuntimeException("TestNotification could not be converted")));
                if (this.receivedNotifications.size() == COUNT) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }
        });
        subscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        TransportBinding transportBinding = this.transportBindingFactory.createHttpBinding(((SubscriptionManager)this.devicePeer.getDevice().getActiveSubscriptions().values().stream().findFirst().get()).getSubscriptionManagerEpr().getAddress().getValue());
        RequestResponseClient requestResponseClient = this.requestResponseClientFactory.createRequestResponseClient((RequestResponseCallback)transportBinding);
        Optional subscriptionManagerOpt = this.devicePeer.getDevice().getActiveSubscriptions().values().stream().findFirst();
        Assertions.assertTrue((boolean)subscriptionManagerOpt.isPresent());
        this.testWseActions((SubscriptionManager)subscriptionManagerOpt.get(), requestResponseClient);
    }

    @Test
    void testSubscriptionProviderHostedServiceEndpoint() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        final int COUNT = 100;
        final SettableFuture notificationFuture = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        ListenableFuture subscribe = srv1.getEventSinkAccess().subscribe(Collections.singletonList("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification"), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification(NotificationObject message) {
                this.receivedNotifications.add((TestNotification)SubscriptionIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).orElseThrow(() -> new RuntimeException("TestNotification could not be converted")));
                if (this.receivedNotifications.size() == COUNT) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }
        });
        subscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        TransportBinding transportBinding = this.transportBindingFactory.createHttpBinding(srv1.getActiveEprAddress());
        RequestResponseClient requestResponseClient = this.requestResponseClientFactory.createRequestResponseClient((RequestResponseCallback)transportBinding);
        Optional subscriptionManagerOpt = this.devicePeer.getDevice().getActiveSubscriptions().values().stream().findFirst();
        Assertions.assertTrue((boolean)subscriptionManagerOpt.isPresent());
        this.testWseActions((SubscriptionManager)subscriptionManagerOpt.get(), requestResponseClient);
    }

    private void testWseActions(SubscriptionManager subscription, RequestResponseClient requestResponseClient) throws Exception {
        SoapMessage getStatus = this.soapUtil.createMessage("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus", (Object)this.wseFactory.createGetStatus());
        getStatus.getWsAddressingHeader().setTo(subscription.getSubscriptionManagerEpr().getAddress());
        SoapMessage response = requestResponseClient.sendRequestResponse(getStatus);
        this.soapUtil.getBody(response, GetStatusResponse.class);
        Renew renewMessageBody = this.wseFactory.createRenew();
        renewMessageBody.setExpires(Duration.ofSeconds(120L));
        SoapMessage renewMessage = this.soapUtil.createMessage("http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew", (Object)renewMessageBody);
        renewMessage.getWsAddressingHeader().setTo(subscription.getSubscriptionManagerEpr().getAddress());
        SoapMessage renewResponse = requestResponseClient.sendRequestResponse(renewMessage);
        this.soapUtil.getBody(renewResponse, RenewResponse.class);
        SoapMessage unsubscribeMessage = this.soapUtil.createMessage("http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe", (Object)this.wseFactory.createUnsubscribe());
        unsubscribeMessage.getWsAddressingHeader().setTo(subscription.getSubscriptionManagerEpr().getAddress());
        requestResponseClient.sendRequestResponse(unsubscribeMessage);
    }

    @Test
    void testSubscriptionConsumer() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        final int COUNT = 100;
        final SettableFuture notificationFuture = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        ListenableFuture subscribe = srv1.getEventSinkAccess().subscribe(Collections.singletonList("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification"), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification(NotificationObject message) {
                this.receivedNotifications.add((TestNotification)SubscriptionIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).orElseThrow(() -> new RuntimeException("TestNotification could not be converted")));
                if (this.receivedNotifications.size() == COUNT) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }
        });
        SubscribeResult subscribeResult = (SubscribeResult)subscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)this.devicePeer.getDevice().getActiveSubscriptions().size());
        ListenableFuture currentDuration = srv1.getEventSinkAccess().getStatus(subscribeResult.getSubscriptionId());
        Duration currentDurationResult = (Duration)currentDuration.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        ListenableFuture renewSubscription = srv1.getEventSinkAccess().renew(subscribeResult.getSubscriptionId(), Duration.ofMinutes(2L));
        renewSubscription.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        ListenableFuture newDuration = srv1.getEventSinkAccess().getStatus(subscribeResult.getSubscriptionId());
        Duration newDurationResult = (Duration)newDuration.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertTrue((0 < newDurationResult.compareTo(currentDurationResult) ? 1 : 0) != 0);
        ListenableFuture unsubscribe = srv1.getEventSinkAccess().unsubscribe(subscribeResult.getSubscriptionId());
        unsubscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((int)0, (int)this.devicePeer.getDevice().getActiveSubscriptions().size());
        Map<String, ByteArrayOutputStream> allRequests = this.logSink.getOutbound();
        Map<String, Optional<String>> allRequestUris = this.logSink.getRequestUris();
        Map<String, ListMultimap<String, String>> allOutboundHeaders = this.logSink.getOutboundHeaders();
        Map<String, String> allSchemes = this.logSink.getSchemes();
        this.checkLogSinkConsistency(allRequests, allRequestUris, allOutboundHeaders, allSchemes);
        this.seenWseMessageWithCorrectRequestUri("http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus", allRequests, allRequestUris, allOutboundHeaders, allSchemes);
        this.seenWseMessageWithCorrectRequestUri("http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew", allRequests, allRequestUris, allOutboundHeaders, allSchemes);
        this.seenWseMessageWithCorrectRequestUri("http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe", allRequests, allRequestUris, allOutboundHeaders, allSchemes);
    }

    private void checkLogSinkConsistency(Map<String, ByteArrayOutputStream> requests, Map<String, Optional<String>> requestUris, Map<String, ListMultimap<String, String>> outboundHeaders, Map<String, String> schemes) {
        Assertions.assertFalse((boolean)requests.isEmpty());
        Assertions.assertEquals(requests.keySet(), requestUris.keySet());
        Assertions.assertEquals(requests.keySet(), outboundHeaders.keySet());
        Assertions.assertEquals(requests.keySet(), schemes.keySet());
    }

    private void seenWseMessageWithCorrectRequestUri(String wseAction, Map<String, ByteArrayOutputStream> requests, Map<String, Optional<String>> requestUris, Map<String, ListMultimap<String, String>> outboundHeaders, Map<String, String> schemes) throws Exception {
        AtomicBoolean seenWseAction = new AtomicBoolean(false);
        for (String transactionId : requests.keySet()) {
            SoapMessage request = this.marshallingService.unmarshal((InputStream)new ByteArrayInputStream(requests.get(transactionId).toByteArray()));
            Optional requestAction = request.getWsAddressingHeader().getAction();
            Assertions.assertTrue((boolean)requestAction.isPresent());
            Optional<String> requestUri = requestUris.get(transactionId);
            if (!((AttributedURIType)requestAction.get()).getValue().equals(wseAction)) continue;
            seenWseAction.set(true);
            Assertions.assertTrue((boolean)requestUri.isPresent());
            Optional wsaToHeader = request.getWsAddressingHeader().getTo();
            Assertions.assertTrue((boolean)wsaToHeader.isPresent());
            String reconstructedUri = this.reconstructUri(schemes.get(transactionId), outboundHeaders.get(transactionId), requestUri.get());
            Assertions.assertNotNull((Object)reconstructedUri, (String)"Uri could not be reconstructed.");
            Assertions.assertEquals((Object)((AttributedURIType)wsaToHeader.get()).getValue(), (Object)reconstructedUri);
        }
        Assertions.assertTrue((boolean)seenWseAction.get());
    }

    private String reconstructUri(String scheme, ListMultimap<String, String> headers, String requestUri) {
        String authority;
        String absolutePath;
        String absoluteUri;
        if (requestUri.equals("*")) {
            return requestUri;
        }
        Matcher matcher = URI_PATTERN.matcher(requestUri);
        if (matcher.matches() && (absoluteUri = matcher.group("absoluteUri")) != null) {
            return absoluteUri;
        }
        Matcher absPathMatcher = ABS_PATH_PATTERN.matcher(requestUri);
        if (absPathMatcher.matches() && (absolutePath = absPathMatcher.group(0)) != null) {
            scheme = (String)scheme + "://";
            String host = (String)headers.get((Object)"host").get(0);
            return (String)scheme + host + absolutePath;
        }
        Matcher authMatcher = AUTHORITY_PATTERN.matcher(requestUri);
        if (authMatcher.matches() && (authority = authMatcher.group(0)) != null) {
            return authority;
        }
        return null;
    }

    static class TestCommLogSink
    implements CommunicationLogSink {
        private final Map<String, ByteArrayOutputStream> outbound = new HashMap<String, ByteArrayOutputStream>();
        private CommunicationLog.MessageType outboundMessageType;
        private final ArrayList<String> outboundTransactionIds = new ArrayList();
        private final Map<String, ListMultimap<String, String>> outboundHeaders;
        private final Map<String, Optional<String>> requestUris = new HashMap<String, Optional<String>>();
        private final Map<String, String> schemes;

        TestCommLogSink() {
            this.outboundHeaders = new HashMap<String, ListMultimap<String, String>>();
            this.schemes = new HashMap<String, String>();
        }

        public OutputStream createTargetStream(CommunicationLog.TransportType path, CommunicationLog.Direction direction, CommunicationLog.MessageType messageType, CommunicationContext communicationContext) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            HttpApplicationInfo appInfo = (HttpApplicationInfo)communicationContext.getApplicationInfo();
            if (CommunicationLog.Direction.OUTBOUND.equals((Object)direction)) {
                this.schemes.put(appInfo.getTransactionId(), communicationContext.getTransportInfo().getScheme());
                this.outbound.put(appInfo.getTransactionId(), os);
                this.outboundMessageType = messageType;
                this.outboundHeaders.put(appInfo.getTransactionId(), (ListMultimap<String, String>)appInfo.getHeaders());
                this.outboundTransactionIds.add(appInfo.getTransactionId());
                this.requestUris.put(appInfo.getTransactionId(), appInfo.getRequestUri());
            }
            return os;
        }

        public Map<String, ByteArrayOutputStream> getOutbound() {
            return this.outbound;
        }

        public void clear() {
            this.outbound.clear();
            this.requestUris.clear();
        }

        public CommunicationLog.MessageType getOutboundMessageType() {
            return this.outboundMessageType;
        }

        public Map<String, ListMultimap<String, String>> getOutboundHeaders() {
            return this.outboundHeaders;
        }

        public ArrayList<String> getOutboundTransactionIds() {
            return this.outboundTransactionIds;
        }

        public Map<String, Optional<String>> getRequestUris() {
            return this.requestUris;
        }

        public Map<String, String> getSchemes() {
            return this.schemes;
        }
    }
}

