/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogImpl;
import org.somda.sdc.dpws.CommunicationLogSink;
import org.somda.sdc.dpws.CommunicationLogSinkImpl;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.TransportInfo;

class CommunicationLogImplTest
extends DpwsTest {
    CommunicationLogImplTest() {
    }

    @Test
    void content() throws IOException {
        CommunicationLogSinkImpl communicationLogSinkImplMock = (CommunicationLogSinkImpl)Mockito.mock(CommunicationLogSinkImpl.class);
        byte[] content = UUID.randomUUID().toString().getBytes();
        try (ByteArrayOutputStream mockOutputStream = (ByteArrayOutputStream)Mockito.spy((Object)new ByteArrayOutputStream());
             ByteArrayInputStream inputTestInputStream = new ByteArrayInputStream(content);
             ByteArrayOutputStream outputTestOutputStream = new ByteArrayOutputStream();){
            Mockito.when((Object)communicationLogSinkImplMock.createTargetStream((CommunicationLog.TransportType)ArgumentMatchers.eq((Object)CommunicationLog.TransportType.HTTP), (CommunicationLog.Direction)ArgumentMatchers.any(), (CommunicationLog.MessageType)ArgumentMatchers.any(), (CommunicationContext)ArgumentMatchers.any())).thenReturn((Object)mockOutputStream);
            CommunicationLogImpl communicationLogImpl = new CommunicationLogImpl((CommunicationLogSink)communicationLogSinkImplMock, "abcd");
            CommunicationContext requestCommContext = new CommunicationContext(null, new TransportInfo("", null, null, "_", Integer.valueOf(0), Collections.emptyList()));
            InputStream resultingInputStream = communicationLogImpl.logMessage(CommunicationLog.Direction.OUTBOUND, CommunicationLog.TransportType.HTTP, CommunicationLog.MessageType.UNKNOWN, requestCommContext, (InputStream)inputTestInputStream);
            Assertions.assertArrayEquals((byte[])resultingInputStream.readAllBytes(), (byte[])content);
            Assertions.assertArrayEquals((byte[])mockOutputStream.toByteArray(), (byte[])content);
            ((ByteArrayOutputStream)Mockito.verify((Object)mockOutputStream, (VerificationMode)Mockito.times((int)1))).close();
            mockOutputStream.reset();
            try (TeeOutputStream resultingOutputStream = communicationLogImpl.logMessage(CommunicationLog.Direction.OUTBOUND, CommunicationLog.TransportType.HTTP, CommunicationLog.MessageType.UNKNOWN, requestCommContext, (OutputStream)outputTestOutputStream);){
                resultingOutputStream.write(content);
                resultingOutputStream.flush();
            }
            Assertions.assertArrayEquals((byte[])outputTestOutputStream.toByteArray(), (byte[])content);
            Assertions.assertArrayEquals((byte[])mockOutputStream.toByteArray(), (byte[])content);
        }
    }

    @Test
    void branchPath() throws IOException {
        byte[] content = UUID.randomUUID().toString().getBytes();
        CommunicationLogSinkImpl communicationLogSinkImplMock = (CommunicationLogSinkImpl)Mockito.mock(CommunicationLogSinkImpl.class);
        CommunicationLogImpl communicationLogImpl = new CommunicationLogImpl((CommunicationLogSink)communicationLogSinkImplMock, "abcd");
        CommunicationContext requestCommContext = new CommunicationContext(null, new TransportInfo("", null, null, "_", Integer.valueOf(0), Collections.emptyList()));
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(content);){
            for (CommunicationLog.Direction dir : CommunicationLog.Direction.values()) {
                Mockito.reset((Object[])new CommunicationLogSinkImpl[]{communicationLogSinkImplMock});
                Mockito.when((Object)communicationLogSinkImplMock.createTargetStream((CommunicationLog.TransportType)ArgumentMatchers.any(CommunicationLog.TransportType.class), (CommunicationLog.Direction)ArgumentMatchers.any(), (CommunicationLog.MessageType)ArgumentMatchers.any(), (CommunicationContext)ArgumentMatchers.any())).thenReturn((Object)OutputStream.nullOutputStream());
                communicationLogImpl.logMessage(dir, CommunicationLog.TransportType.HTTP, CommunicationLog.MessageType.UNKNOWN, requestCommContext, (InputStream)inputStream);
                communicationLogImpl.logMessage(dir, CommunicationLog.TransportType.HTTP, CommunicationLog.MessageType.UNKNOWN, requestCommContext, OutputStream.nullOutputStream());
                ((CommunicationLogSinkImpl)Mockito.verify((Object)communicationLogSinkImplMock, (VerificationMode)Mockito.times((int)2))).createTargetStream((CommunicationLog.TransportType)ArgumentMatchers.eq((Object)CommunicationLog.TransportType.HTTP), (CommunicationLog.Direction)ArgumentMatchers.any(), (CommunicationLog.MessageType)ArgumentMatchers.any(), (CommunicationContext)ArgumentMatchers.any());
            }
        }
    }
}

