/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.device.helper;

import java.net.URI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.somda.sdc.dpws.device.helper.UriBaseContextPath;
import test.org.somda.common.LoggingTestWatcher;

@ExtendWith(value={LoggingTestWatcher.class})
class UriBaseContextPathTest {
    final String expectedUrlPath = "/context/path";
    final String expectedUrnUuidSpecificPart = "uuid:550e8400-e29b-11d4-a716-446655440000";
    final String expectedUrnOidSpecificPart = "oid:1.3.6.1.4.1";
    final URI testUrl = URI.create("http://www.examp.le/context/path");
    final URI testUuid = URI.create("urn:uuid:550e8400-e29b-11d4-a716-446655440000");
    final URI testOid = URI.create("urn:oid:1.3.6.1.4.1");

    UriBaseContextPathTest() {
    }

    @Test
    void uriParts() {
        Assertions.assertEquals((Object)"/context/path", (Object)this.testUrl.getPath());
        Assertions.assertEquals((Object)"uuid:550e8400-e29b-11d4-a716-446655440000", (Object)this.testUuid.getSchemeSpecificPart());
        Assertions.assertEquals((Object)"oid:1.3.6.1.4.1", (Object)this.testOid.getSchemeSpecificPart());
    }

    @Test
    void basePathDerivation() {
        String expectedUrlBasePath = "/context/path".substring(1);
        String expectedUuidBasePath = "uuid:550e8400-e29b-11d4-a716-446655440000".substring("uuid:".length());
        String expectedOidBasePath = "oid:1.3.6.1.4.1".substring("oid:".length());
        Assertions.assertEquals((Object)expectedUrlBasePath, (Object)new UriBaseContextPath(this.testUrl.toString()).get());
        Assertions.assertEquals((Object)expectedUuidBasePath, (Object)new UriBaseContextPath(this.testUuid.toString()).get());
        Assertions.assertEquals((Object)expectedOidBasePath, (Object)new UriBaseContextPath(this.testOid.toString()).get());
        Assertions.assertEquals((Object)"", (Object)new UriBaseContextPath("urn:foo:bar:1234").get());
    }
}

