/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.helper;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.helper.CommunicationLogSoapXmlUtils;

class CommunicationLogSoapXmlUtilsTest {
    private String soapInputWithDpwsAction = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<s12:Envelope xmlns=\"http://standards.ieee.org/downloads/11073/11073-10207-2017/extension\" xmlns:ns2=\"http://standards.ieee.org/downloads/11073/11073-10207-2017/participant\" xmlns:ns3=\"http://standards.ieee.org/downloads/11073/11073-10207-2017/message\" xmlns:s12=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:dpws=\"http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01\" xmlns:wsa=\"http://www.w3.org/2005/08/addressing\" xmlns:wsd=\"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01\" xmlns:wse=\"http://schemas.xmlsoap.org/ws/2004/08/eventing\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2004/09/transfer\" xmlns:wsm=\"http://schemas.xmlsoap.org/ws/2004/09/mex\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><s12:Header><wsa:Action>http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe</wsa:Action><wsa:MessageID>urn:uuid:031aac5c-1f10-4e1d-a9f1-5ded6d14da6e</wsa:MessageID></s12:Header><s12:Body><wse:Subscribe><wse:EndTo><wsa:Address>http://127.0.0.1:50888/EventSink/EndTo/479e972d-c70a-49c1-aadf-72730febe471</wsa:Address></wse:EndTo><wse:Delivery Mode=\"http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push\"><wse:NotifyTo><wsa:Address>http://127.0.0.1:50901/EventSink/NotifyTo/479e972d-c70a-49c1-aadf-72730febe471</wsa:Address></wse:NotifyTo></wse:Delivery><wse:Expires>PT20S</wse:Expires><wse:Filter Dialect=\"http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Action\">http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicAlertReport http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicComponentReport http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/PeriodicContextReport http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicMetricReport http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicOperationalStateReport http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream</wse:Filter></wse:Subscribe></s12:Body></s12:Envelope>";
    private String soapInputWithoutDpwsAction = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<s12:Envelope xmlns=\"http://standards.ieee.org/downloads/11073/11073-10207-2017/extension\" xmlns:ns2=\"http://standards.ieee.org/downloads/11073/11073-10207-2017/participant\" xmlns:ns3=\"http://standards.ieee.org/downloads/11073/11073-10207-2017/message\" xmlns:s12=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:dpws=\"http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01\" xmlns:wsa=\"http://www.w3.org/2005/08/addressing\" xmlns:wsd=\"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01\" xmlns:wse=\"http://schemas.xmlsoap.org/ws/2004/08/eventing\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2004/09/transfer\" xmlns:wsm=\"http://schemas.xmlsoap.org/ws/2004/09/mex\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><s12:Header><wsa:Action>ThisIsAnUnknownOne/Foobar</wsa:Action><wsa:MessageID>urn:uuid:031aac5c-1f10-4e1d-a9f1-5ded6d14da6e</wsa:MessageID></s12:Header><s12:Body><wse:Subscribe><wse:EndTo><wsa:Address>http://127.0.0.1:50888/EventSink/EndTo/479e972d-c70a-49c1-aadf-72730febe471</wsa:Address></wse:EndTo><wse:Delivery Mode=\"http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push\"><wse:NotifyTo><wsa:Address>http://127.0.0.1:50901/EventSink/NotifyTo/479e972d-c70a-49c1-aadf-72730febe471</wsa:Address></wse:NotifyTo></wse:Delivery><wse:Expires>PT20S</wse:Expires><wse:Filter Dialect=\"http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Action\">http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicAlertReport http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicComponentReport http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/PeriodicContextReport http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicMetricReport http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicOperationalStateReport http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream</wse:Filter></wse:Subscribe></s12:Body></s12:Envelope>";
    private String soapInputWithoutAnyAction = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<s12:Envelope xmlns=\"http://standards.ieee.org/downloads/11073/11073-10207-2017/extension\" xmlns:ns2=\"http://standards.ieee.org/downloads/11073/11073-10207-2017/participant\" xmlns:ns3=\"http://standards.ieee.org/downloads/11073/11073-10207-2017/message\" xmlns:s12=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:dpws=\"http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01\" xmlns:wsa=\"http://www.w3.org/2005/08/addressing\" xmlns:wsd=\"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01\" xmlns:wse=\"http://schemas.xmlsoap.org/ws/2004/08/eventing\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2004/09/transfer\" xmlns:wsm=\"http://schemas.xmlsoap.org/ws/2004/09/mex\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><s12:Header><wsa:MessageID>urn:uuid:031aac5c-1f10-4e1d-a9f1-5ded6d14da6e</wsa:MessageID></s12:Header><s12:Body><wse:Subscribe><wse:EndTo><wsa:Address>http://127.0.0.1:50888/EventSink/EndTo/479e972d-c70a-49c1-aadf-72730febe471</wsa:Address></wse:EndTo><wse:Delivery Mode=\"http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push\"><wse:NotifyTo><wsa:Address>http://127.0.0.1:50901/EventSink/NotifyTo/479e972d-c70a-49c1-aadf-72730febe471</wsa:Address></wse:NotifyTo></wse:Delivery><wse:Expires>PT20S</wse:Expires><wse:Filter Dialect=\"http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Action\">http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicAlertReport http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicComponentReport http://standards.ieee.org/downloads/11073/11073-20701-2018/ContextService/PeriodicContextReport http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicMetricReport http://standards.ieee.org/downloads/11073/11073-20701-2018/StateEventService/PeriodicOperationalStateReport http://standards.ieee.org/downloads/11073/11073-20701-2018/WaveformService/WaveformStream</wse:Filter></wse:Subscribe></s12:Body></s12:Envelope>";

    CommunicationLogSoapXmlUtilsTest() {
    }

    @Test
    void makeNameElement() {
        CommunicationLogSoapXmlUtils soapXmlUtils = new CommunicationLogSoapXmlUtils();
        String name = soapXmlUtils.makeNameElement(this.soapInputWithDpwsAction.getBytes());
        Assertions.assertEquals((Object)"WseSubscribe", (Object)name);
        name = soapXmlUtils.makeNameElement(this.soapInputWithoutDpwsAction.getBytes());
        Assertions.assertEquals((Object)"Foobar", (Object)name);
        name = soapXmlUtils.makeNameElement(this.soapInputWithoutAnyAction.getBytes());
        Assertions.assertEquals((Object)"[unknown]", (Object)name);
        name = soapXmlUtils.makeNameElement(new byte[0]);
        Assertions.assertEquals((Object)"[empty]", (Object)name);
    }
}

