/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import com.google.inject.AbstractModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.MarshalException;
import javax.xml.bind.UnmarshalException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.common.guice.AbstractConfigurationModule;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.NetworkSinkMock;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.HelloType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ObjectFactory;

class JaxbSoapMarshallingSchemaTest
extends DpwsTest {
    JaxbSoapMarshallingSchemaTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.overrideBindings((AbstractModule)new AbstractConfigurationModule(){

            protected void defaultConfigure() {
                this.bind("SoapConfig.ValidateSoapMessages", Boolean.class, true);
            }
        });
        super.setUp();
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).startAsync().awaitRunning();
    }

    @Test
    void marshallValidMessage() throws Exception {
        ObjectFactory wsdFactory = (ObjectFactory)this.getInjector().getInstance(ObjectFactory.class);
        HelloType helloType = wsdFactory.createHelloType();
        org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory wsaFactory = (org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory)this.getInjector().getInstance(org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory.class);
        EndpointReferenceType expectedEpr = wsaFactory.createEndpointReferenceType();
        AttributedURIType eprAddress = wsaFactory.createAttributedURIType();
        eprAddress.setValue("http://test-xAddr1");
        expectedEpr.setAddress(eprAddress);
        helloType.setEndpointReference(expectedEpr);
        ArrayList<String> xAddrs = new ArrayList<String>();
        xAddrs.add("http://test-xAddr1");
        xAddrs.add("http://test-xAddr2");
        helloType.setXAddrs(xAddrs);
        JAXBElement expectedHello = wsdFactory.createHello(helloType);
        EnvelopeFactory envelopeFactory = (EnvelopeFactory)this.getInjector().getInstance(EnvelopeFactory.class);
        Envelope expectedEnvelope = envelopeFactory.createEnvelope("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello", "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01", (Object)expectedHello);
        SoapMarshalling marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        NetworkSinkMock mockNetworkSink = (NetworkSinkMock)this.getInjector().getInstance(NetworkSinkMock.class);
        try (OutputStream os = mockNetworkSink.createOutputStream();){
            marshalling.marshal(expectedEnvelope, os);
        }
    }

    @Test
    void marshallInvalidMessage() throws Exception {
        ObjectFactory wsdFactory = (ObjectFactory)this.getInjector().getInstance(ObjectFactory.class);
        HelloType helloType = wsdFactory.createHelloType();
        ArrayList<String> xAddrs = new ArrayList<String>();
        xAddrs.add("http://test-xAddr1");
        xAddrs.add("http://test-xAddr2");
        helloType.setXAddrs(xAddrs);
        JAXBElement expectedHello = wsdFactory.createHello(helloType);
        EnvelopeFactory envelopeFactory = (EnvelopeFactory)this.getInjector().getInstance(EnvelopeFactory.class);
        Envelope expectedEnvelope = envelopeFactory.createEnvelope("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello", "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01", (Object)expectedHello);
        SoapMarshalling marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        NetworkSinkMock mockNetworkSink = (NetworkSinkMock)this.getInjector().getInstance(NetworkSinkMock.class);
        Assertions.assertThrows(MarshalException.class, () -> {
            try (OutputStream os = mockNetworkSink.createOutputStream();){
                marshalling.marshal(expectedEnvelope, os);
            }
        });
    }

    @Test
    void testUnmarshallingValidMessage() throws Exception {
        ObjectFactory wsdFactory = (ObjectFactory)this.getInjector().getInstance(ObjectFactory.class);
        HelloType helloType = wsdFactory.createHelloType();
        org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory wsaFactory = (org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory)this.getInjector().getInstance(org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory.class);
        EndpointReferenceType expectedEpr = wsaFactory.createEndpointReferenceType();
        AttributedURIType eprAddress = wsaFactory.createAttributedURIType();
        eprAddress.setValue("http://test-xAddr1");
        expectedEpr.setAddress(eprAddress);
        helloType.setEndpointReference(expectedEpr);
        ArrayList<String> xAddrs = new ArrayList<String>();
        xAddrs.add("http://test-xAddr1");
        xAddrs.add("http://test-xAddr2");
        helloType.setXAddrs(xAddrs);
        JAXBElement expectedHello = wsdFactory.createHello(helloType);
        EnvelopeFactory envelopeFactory = (EnvelopeFactory)this.getInjector().getInstance(EnvelopeFactory.class);
        Envelope expectedEnvelope = envelopeFactory.createEnvelope("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello", "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01", (Object)expectedHello);
        SoapMarshalling marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        marshalling.marshal(expectedEnvelope, (OutputStream)os);
        System.out.println(new String(os.toByteArray()));
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        Envelope result = marshalling.unmarshal((InputStream)is);
        JAXBElement resultHello = (JAXBElement)result.getBody().getAny().get(0);
        Assertions.assertEquals((Object)((HelloType)resultHello.getValue()).getEndpointReference().getAddress().getValue(), (Object)expectedEpr.getAddress().getValue());
    }

    @Test
    void unmarshallInvalidMessage() throws Exception {
        String wrongMessage = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<s12:Envelope xmlns:s12=\"http://www.w3.org/2003/05/soap-envelope\" \n    xmlns:wsa=\"http://www.w3.org/2005/08/addressing\" \n    xmlns:dpws=\"http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01\" \n    xmlns:ns4=\"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01\" \n    xmlns:wse=\"http://schemas.xmlsoap.org/ws/2004/08/eventing\" \n    xmlns:wst=\"http://schemas.xmlsoap.org/ws/2004/09/transfer\" \n    xmlns:wsm=\"http://schemas.xmlsoap.org/ws/2004/09/mex\" \n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n    xmlns:wsd=\"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/\">\n    <s12:Header>\n        <wsa:Action>http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello</wsa:Action>\n        <wsa:To>urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01</wsa:To>\n    </s12:Header>\n    <s12:Body>\n        <ns4:Hello>\n            <ns4:XAddrs>http://test-xAddr1 http://test-xAddr2</ns4:XAddrs>\n            <ns4:MetadataVersion>0</ns4:MetadataVersion>\n        </ns4:Hello>\n    </s12:Body>\n</s12:Envelope>\n";
        ByteArrayInputStream is = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<s12:Envelope xmlns:s12=\"http://www.w3.org/2003/05/soap-envelope\" \n    xmlns:wsa=\"http://www.w3.org/2005/08/addressing\" \n    xmlns:dpws=\"http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01\" \n    xmlns:ns4=\"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01\" \n    xmlns:wse=\"http://schemas.xmlsoap.org/ws/2004/08/eventing\" \n    xmlns:wst=\"http://schemas.xmlsoap.org/ws/2004/09/transfer\" \n    xmlns:wsm=\"http://schemas.xmlsoap.org/ws/2004/09/mex\" \n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n    xmlns:wsd=\"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/\">\n    <s12:Header>\n        <wsa:Action>http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello</wsa:Action>\n        <wsa:To>urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01</wsa:To>\n    </s12:Header>\n    <s12:Body>\n        <ns4:Hello>\n            <ns4:XAddrs>http://test-xAddr1 http://test-xAddr2</ns4:XAddrs>\n            <ns4:MetadataVersion>0</ns4:MetadataVersion>\n        </ns4:Hello>\n    </s12:Body>\n</s12:Envelope>\n".getBytes(Charset.defaultCharset()));
        SoapMarshalling marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        Assertions.assertThrows(UnmarshalException.class, () -> marshalling.unmarshal((InputStream)is));
    }
}

