/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.NotificationSink;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.factory.NotificationSinkFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.interception.RequestObject;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingServerInterceptor;

class NotificationSinkImplTest
extends DpwsTest {
    private List<String> dispatchedSequence;

    NotificationSinkImplTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).startAsync().awaitRunning();
        this.dispatchedSequence = new ArrayList<String>();
    }

    @Test
    void receiveNotification() throws Exception {
        SoapMarshalling unmarshaller = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        NotificationSink nSink = ((NotificationSinkFactory)this.getInjector().getInstance(NotificationSinkFactory.class)).createNotificationSink((WsAddressingServerInterceptor)this.getInjector().getInstance(WsAddressingServerInterceptor.class));
        Envelope soapEnv = unmarshaller.unmarshal(this.getClass().getResourceAsStream("soap-envelope.xml"));
        SoapMessageFactory soapMessageFactory = (SoapMessageFactory)this.getInjector().getInstance(SoapMessageFactory.class);
        SoapMessage notification = soapMessageFactory.createSoapMessage(soapEnv);
        nSink.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.NOTIFICATION)
            void onDelete(NotificationObject nInfo) {
                NotificationSinkImplTest.this.dispatchedSequence.add("NOTIFICATION(MAX)");
            }
        });
        nSink.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.NOTIFICATION, sequenceNumber=5)
            void onDelete(NotificationObject nInfo) {
                NotificationSinkImplTest.this.dispatchedSequence.add("NOTIFICATION(5)");
            }
        });
        nSink.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.NOTIFICATION)
            void onDelete(NotificationObject nInfo) {
                NotificationSinkImplTest.this.dispatchedSequence.add("NOTIFICATION(ACTION, MAX)");
            }
        });
        nSink.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.NOTIFICATION)
            void onDelete() {
                NotificationSinkImplTest.this.dispatchedSequence.add("INVALID NOTIFICATION(ACTION, MAX)");
            }
        });
        nSink.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.RESPONSE)
            void onDelete(NotificationObject nInfo) {
                NotificationSinkImplTest.this.dispatchedSequence.add("INVALID NOTIFICATION(MAX)");
            }
        });
        nSink.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.NOTIFICATION)
            void onDelete(RequestObject rInfo) {
                NotificationSinkImplTest.this.dispatchedSequence.add("INVALID NOTIFICATION(ACTION, MAX)");
            }
        });
        CommunicationContext commMock = (CommunicationContext)Mockito.mock(CommunicationContext.class);
        TransportInfo transportInfoMock = (TransportInfo)Mockito.mock(TransportInfo.class);
        Mockito.when((Object)commMock.getTransportInfo()).thenReturn((Object)transportInfoMock);
        Mockito.when((Object)transportInfoMock.getScheme()).thenReturn((Object)"any");
        nSink.receiveNotification(notification, commMock);
        Assertions.assertEquals((int)3, (int)this.dispatchedSequence.size());
        Assertions.assertEquals((Object)"NOTIFICATION(5)", (Object)this.dispatchedSequence.get(0));
        Assertions.assertEquals((Object)"NOTIFICATION(MAX)", (Object)this.dispatchedSequence.get(1));
        Assertions.assertEquals((Object)"NOTIFICATION(ACTION, MAX)", (Object)this.dispatchedSequence.get(2));
    }
}

