/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestObject;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;

class RequestResponseClientImplTest
extends DpwsTest {
    private List<String> dispatchedSequence;

    RequestResponseClientImplTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).startAsync().awaitRunning();
        this.dispatchedSequence = new ArrayList<String>();
    }

    @Test
    void sendRequestResponse() throws Exception {
        SoapMarshalling unmarshaller = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        Envelope soapEnv = unmarshaller.unmarshal(this.getClass().getResourceAsStream("soap-envelope.xml"));
        SoapUtil soapUtil = (SoapUtil)this.getInjector().getInstance(SoapUtil.class);
        SoapMessage request = soapUtil.createMessage(soapEnv);
        SoapMessage response = soapUtil.createMessage();
        AttributedURIType responseAction = ((WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class)).createAttributedURIType("http://response-action");
        response.getWsAddressingHeader().setAction(responseAction);
        RequestResponseClientFactory clientFactory = (RequestResponseClientFactory)this.getInjector().getInstance(RequestResponseClientFactory.class);
        RequestResponseClient rrClient = clientFactory.createRequestResponseClient(req -> {
            this.dispatchedSequence.add("NETWORK");
            return response;
        });
        rrClient.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.REQUEST)
            void onDelete(RequestObject rInfo) {
                RequestResponseClientImplTest.this.dispatchedSequence.add("REQUEST(MAX)");
            }
        });
        rrClient.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.REQUEST, sequenceNumber=5)
            void onDelete(RequestObject rInfo) {
                RequestResponseClientImplTest.this.dispatchedSequence.add("REQUEST(5)");
            }
        });
        rrClient.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.REQUEST)
            void onDelete(RequestObject rInfo) {
                RequestResponseClientImplTest.this.dispatchedSequence.add("REQUEST(ACTION, MAX)");
            }
        });
        rrClient.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.REQUEST)
            void onDelete() {
                RequestResponseClientImplTest.this.dispatchedSequence.add("INVALID REQUEST(ACTION, MAX)");
            }
        });
        rrClient.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.REQUEST)
            void onDelete(RequestResponseObject rrInfo) {
                RequestResponseClientImplTest.this.dispatchedSequence.add("INVALID REQUEST(ACTION, MAX)");
            }
        });
        rrClient.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.RESPONSE)
            void onDelete(RequestResponseObject rrInfo) {
                RequestResponseClientImplTest.this.dispatchedSequence.add("RESPONSE(MAX)");
            }
        });
        rrClient.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.RESPONSE)
            void onDelete(RequestResponseObject rrInfo) {
                RequestResponseClientImplTest.this.dispatchedSequence.add("INVALID RESPONSE(ACTION, MAX)");
            }
        });
        rrClient.register(new Interceptor(){

            @MessageInterceptor(value="http://response-action", direction=Direction.RESPONSE)
            void onDelete(RequestResponseObject rrInfo) {
                RequestResponseClientImplTest.this.dispatchedSequence.add("RESPONSE(ACTION,MAX)");
            }
        });
        Assertions.assertSame((Object)response, (Object)rrClient.sendRequestResponse(request));
        Assertions.assertEquals((int)6, (int)this.dispatchedSequence.size());
        Assertions.assertEquals((Object)"REQUEST(5)", (Object)this.dispatchedSequence.get(0));
        Assertions.assertEquals((Object)"REQUEST(MAX)", (Object)this.dispatchedSequence.get(1));
        Assertions.assertEquals((Object)"REQUEST(ACTION, MAX)", (Object)this.dispatchedSequence.get(2));
        Assertions.assertEquals((Object)"NETWORK", (Object)this.dispatchedSequence.get(3));
        Assertions.assertEquals((Object)"RESPONSE(MAX)", (Object)this.dispatchedSequence.get(4));
        Assertions.assertEquals((Object)"RESPONSE(ACTION,MAX)", (Object)this.dispatchedSequence.get(5));
    }
}

