/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;

class RequestResponseServerImplTest
extends DpwsTest {
    private List<String> dispatchedSequence;
    private CommunicationContext mockCommunicationContext;

    RequestResponseServerImplTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.mockCommunicationContext = new CommunicationContext(new ApplicationInfo(), new TransportInfo("mock.scheme", "localhost", Integer.valueOf(123), "remotehost", Integer.valueOf(456), Collections.emptyList()));
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).startAsync().awaitRunning();
        this.dispatchedSequence = new ArrayList<String>();
    }

    @Test
    void receiveRequestResponse() throws Exception {
        SoapMarshalling unmarshaller = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        RequestResponseServer rrServer = (RequestResponseServer)this.getInjector().getInstance(RequestResponseServer.class);
        Envelope soapEnv = unmarshaller.unmarshal(this.getClass().getResourceAsStream("soap-envelope.xml"));
        SoapMessageFactory soapMessageFactory = (SoapMessageFactory)this.getInjector().getInstance(SoapMessageFactory.class);
        SoapMessage request = soapMessageFactory.createSoapMessage(soapEnv);
        SoapMessage response = soapMessageFactory.createSoapMessage(new Envelope());
        AttributedURIType responseAction = ((WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class)).createAttributedURIType("http://response-action");
        response.getWsAddressingHeader().setAction(responseAction);
        rrServer.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.REQUEST)
            void onDelete(RequestResponseObject rrInfo) {
                RequestResponseServerImplTest.this.dispatchedSequence.add("REQUEST(MAX)");
            }
        });
        rrServer.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.REQUEST, sequenceNumber=5)
            void onDelete(RequestResponseObject rrInfo) {
                RequestResponseServerImplTest.this.dispatchedSequence.add("REQUEST(5)");
            }
        });
        rrServer.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.REQUEST)
            void onDelete(RequestResponseObject rrInfo) {
                RequestResponseServerImplTest.this.dispatchedSequence.add("REQUEST(ACTION, MAX)");
            }
        });
        rrServer.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.REQUEST)
            void onDelete() {
                RequestResponseServerImplTest.this.dispatchedSequence.add("INVALID REQUEST(ACTION, MAX)");
            }
        });
        rrServer.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.RESPONSE)
            void onDelete(RequestResponseObject rrInfo) {
                RequestResponseServerImplTest.this.dispatchedSequence.add("RESPONSE(MAX)");
            }
        });
        rrServer.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.RESPONSE)
            void onDelete(RequestResponseObject rrInfo) {
                RequestResponseServerImplTest.this.dispatchedSequence.add("INVALID RESPONSE(ACTION, MAX)");
            }
        });
        rrServer.register(new Interceptor(){

            @MessageInterceptor(value="http://response-action", direction=Direction.RESPONSE)
            void onDelete(RequestResponseObject rrInfo) {
                RequestResponseServerImplTest.this.dispatchedSequence.add("RESPONSE(ACTION,MAX)");
            }
        });
        rrServer.receiveRequestResponse(request, response, this.mockCommunicationContext);
        Assertions.assertEquals((int)5, (int)this.dispatchedSequence.size());
        Assertions.assertEquals((Object)"REQUEST(5)", (Object)this.dispatchedSequence.get(0));
        Assertions.assertEquals((Object)"REQUEST(MAX)", (Object)this.dispatchedSequence.get(1));
        Assertions.assertEquals((Object)"REQUEST(ACTION, MAX)", (Object)this.dispatchedSequence.get(2));
        Assertions.assertEquals((Object)"RESPONSE(MAX)", (Object)this.dispatchedSequence.get(3));
        Assertions.assertEquals((Object)"RESPONSE(ACTION,MAX)", (Object)this.dispatchedSequence.get(4));
    }
}

