/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsaddressing;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingClientInterceptor;

class WsAddressingClientInterceptorTest
extends DpwsTest {
    private RequestResponseClient client;
    private EnvelopeFactory envelopeFactory;
    private SoapMessageFactory soapMessageFactory;

    WsAddressingClientInterceptorTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.envelopeFactory = (EnvelopeFactory)this.getInjector().getInstance(EnvelopeFactory.class);
        this.soapMessageFactory = (SoapMessageFactory)this.getInjector().getInstance(SoapMessageFactory.class);
        RequestResponseClientFactory requestResponseClientFactory = (RequestResponseClientFactory)this.getInjector().getInstance(RequestResponseClientFactory.class);
        this.client = requestResponseClientFactory.createRequestResponseClient(request -> {
            SoapMessage response = this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope("http://response", null));
            request.getWsAddressingHeader().getMessageId().ifPresent(attributedURIType -> response.getWsAddressingHeader().setMessageId(attributedURIType));
            return response;
        });
        this.client.register((Interceptor)this.getInjector().getInstance(WsAddressingClientInterceptor.class));
    }

    @Test
    void processMessage() throws Exception {
        SoapMessage req = this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope("http://request", null));
        SoapMessage res = this.client.sendRequestResponse(req);
        Assertions.assertTrue((boolean)res.getWsAddressingHeader().getMessageId().isPresent());
    }
}

