/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsdiscovery;

import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.guice.WsDiscovery;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.NotificationSink;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.factory.NotificationSinkFactory;
import org.somda.sdc.dpws.soap.factory.NotificationSourceFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingClientInterceptor;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingServerInterceptor;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.HelloByeAndProbeMatchesObserver;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryClient;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ProbeMatchesMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.factory.WsDiscoveryClientFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchesType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchesType;

class WsDiscoveryClientInterceptorTest
extends DpwsTest {
    private List<SoapMessage> sentSoapMessages;
    private WsDiscoveryClient wsDiscoveryClient;
    private List<QName> expectedTypes;
    private List<String> expectedScopes;
    private NotificationSource notificationSource;
    private EndpointReferenceType expectedEpr;
    private ObjectFactory wsdFactory;
    private SoapMessageFactory soapMessageFactory;
    private EnvelopeFactory envelopeFactory;
    private NotificationSink notificationSink;
    private CommunicationContext communicationContextMock;
    private WsAddressingUtil wsaUtil;

    WsDiscoveryClientInterceptorTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ((ExecutorWrapperService)this.getInjector().getInstance(Key.get((TypeLiteral)new TypeLiteral<ExecutorWrapperService<ListeningExecutorService>>(){}, WsDiscovery.class))).startAsync().awaitRunning();
        this.communicationContextMock = (CommunicationContext)Mockito.mock(CommunicationContext.class);
        TransportInfo transportInfoMock = (TransportInfo)Mockito.mock(TransportInfo.class);
        Mockito.when((Object)this.communicationContextMock.getTransportInfo()).thenReturn((Object)transportInfoMock);
        Mockito.when((Object)transportInfoMock.getScheme()).thenReturn((Object)"any");
        this.soapMessageFactory = (SoapMessageFactory)this.getInjector().getInstance(SoapMessageFactory.class);
        NotificationSourceFactory nSourceFactory = (NotificationSourceFactory)this.getInjector().getInstance(NotificationSourceFactory.class);
        this.sentSoapMessages = new ArrayList<SoapMessage>();
        this.notificationSource = nSourceFactory.createNotificationSource(notification -> this.sentSoapMessages.add(notification));
        this.notificationSink = ((NotificationSinkFactory)this.getInjector().getInstance(NotificationSinkFactory.class)).createNotificationSink((WsAddressingServerInterceptor)this.getInjector().getInstance(WsAddressingServerInterceptor.class));
        this.wsaUtil = (WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class);
        WsDiscoveryClientFactory wsdClientFactory = (WsDiscoveryClientFactory)this.getInjector().getInstance(WsDiscoveryClientFactory.class);
        this.wsDiscoveryClient = wsdClientFactory.createWsDiscoveryClient(this.notificationSource);
        QName expectedType = new QName("http://namespace", "type");
        String expectedScope = "http://namespace/scope";
        String expectedXAddr = "http://1.2.3.4";
        this.expectedTypes = new ArrayList<QName>();
        this.expectedTypes.add(expectedType);
        this.expectedScopes = new ArrayList<String>();
        this.expectedScopes.add(expectedScope);
        org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory wsaFactory = (org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory)this.getInjector().getInstance(org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory.class);
        this.expectedEpr = wsaFactory.createEndpointReferenceType();
        AttributedURIType eprUri = wsaFactory.createAttributedURIType();
        eprUri.setValue("http://expectedEpr-uri");
        this.expectedEpr.setAddress(eprUri);
        this.wsdFactory = (ObjectFactory)this.getInjector().getInstance(ObjectFactory.class);
        this.envelopeFactory = (EnvelopeFactory)this.getInjector().getInstance(EnvelopeFactory.class);
    }

    @Test
    void processProbe() {
        this.processProbeOrResolveRequestWithCallback(() -> {
            try {
                this.wsDiscoveryClient.sendProbe(UUID.randomUUID().toString(), this.expectedTypes, this.expectedScopes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    void processResolve() {
        this.processProbeOrResolveRequestWithCallback(() -> {
            try {
                this.wsDiscoveryClient.sendResolve(this.expectedEpr);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void processProbeOrResolveRequestWithCallback(Runnable r) {
        r.run();
        Assertions.assertEquals((int)1, (int)this.sentSoapMessages.size());
        Assertions.assertFalse((boolean)this.sentSoapMessages.get(0).getWsDiscoveryHeader().getAppSequence().isPresent());
        this.notificationSource.register((Interceptor)this.wsDiscoveryClient);
        r.run();
        Assertions.assertEquals((int)2, (int)this.sentSoapMessages.size());
        Assertions.assertTrue((boolean)this.sentSoapMessages.get(1).getWsDiscoveryHeader().getAppSequence().isPresent());
    }

    @Test
    void sendProbe() throws Exception {
        this.notificationSource.register((Interceptor)this.getInjector().getInstance(WsAddressingClientInterceptor.class));
        this.notificationSource.register((Interceptor)this.wsDiscoveryClient);
        this.notificationSink.register((Interceptor)this.wsDiscoveryClient);
        final String searchId = UUID.randomUUID().toString();
        this.wsDiscoveryClient.registerHelloByeAndProbeMatchesObserver(new HelloByeAndProbeMatchesObserver(){

            @Subscribe
            void onProbe(ProbeMatchesMessage probeMatchesMessage) {
                Assertions.assertEquals((Object)searchId, (Object)probeMatchesMessage.getProbeRequestId());
            }
        });
        ListenableFuture future = this.wsDiscoveryClient.sendProbe(searchId, this.expectedTypes, this.expectedScopes, Integer.valueOf(1));
        Assertions.assertEquals((int)1, (int)this.sentSoapMessages.size());
        this.notificationSink.receiveNotification(this.createProbeMatches(this.sentSoapMessages.get(0)), this.communicationContextMock);
        Assertions.assertEquals((Integer)1, (Integer)((Integer)future.get()));
    }

    @Test
    void sendResolve() throws Exception {
        this.notificationSource.register((Interceptor)this.getInjector().getInstance(WsAddressingClientInterceptor.class));
        this.notificationSource.register((Interceptor)this.wsDiscoveryClient);
        this.notificationSink.register((Interceptor)this.wsDiscoveryClient);
        ListenableFuture result = this.wsDiscoveryClient.sendResolve(this.expectedEpr);
        Assertions.assertEquals((int)1, (int)this.sentSoapMessages.size());
        this.notificationSink.receiveNotification(this.createResolveMatches(this.sentSoapMessages.get(0)), this.communicationContextMock);
        Futures.addCallback((ListenableFuture)result, (FutureCallback)new FutureCallback<ResolveMatchesType>(){

            public void onSuccess(@Nullable ResolveMatchesType resolveMatchesType) {
                Assertions.assertTrue((boolean)true);
            }

            public void onFailure(Throwable throwable) {
                Assertions.fail(throwable::getMessage);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private SoapMessage createResolveMatches(SoapMessage msg) {
        ResolveMatchType resolveMatchType = this.wsdFactory.createResolveMatchType();
        ResolveMatchesType resolveMatchesType = this.wsdFactory.createResolveMatchesType();
        resolveMatchesType.setResolveMatch(resolveMatchType);
        Envelope env = this.envelopeFactory.createEnvelope("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ResolveMatches", "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01", (Object)this.wsdFactory.createResolveMatches(resolveMatchesType));
        SoapMessage rMatches = this.soapMessageFactory.createSoapMessage(env);
        rMatches.getWsAddressingHeader().setRelatesTo(this.wsaUtil.createRelatesToType((AttributedURIType)msg.getWsAddressingHeader().getMessageId().orElse(null)));
        return rMatches;
    }

    private SoapMessage createProbeMatches(SoapMessage msg) {
        ProbeMatchType probeMatchType = this.wsdFactory.createProbeMatchType();
        ProbeMatchesType probeMatchesType = this.wsdFactory.createProbeMatchesType();
        ArrayList<ProbeMatchType> probeMatchTypes = new ArrayList<ProbeMatchType>();
        probeMatchTypes.add(probeMatchType);
        probeMatchesType.setProbeMatch(probeMatchTypes);
        Envelope env = this.envelopeFactory.createEnvelope("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ProbeMatches", "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01", (Object)this.wsdFactory.createProbeMatches(probeMatchesType));
        SoapMessage pMatches = this.soapMessageFactory.createSoapMessage(env);
        pMatches.getWsAddressingHeader().setRelatesTo(this.wsaUtil.createRelatesToType((AttributedURIType)msg.getWsAddressingHeader().getMessageId().orElse(null)));
        String msgId = ((SoapUtil)this.getInjector().getInstance(SoapUtil.class)).createRandomUuidUri();
        AttributedURIType uriType = ((WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class)).createAttributedURIType(msgId);
        pMatches.getWsAddressingHeader().setMessageId(uriType);
        return pMatches;
    }
}

