/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.udp;

import com.google.common.eventbus.Subscribe;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.udp.UdpBindingService;
import org.somda.sdc.dpws.udp.UdpBindingServiceMock;
import org.somda.sdc.dpws.udp.UdpMessage;
import org.somda.sdc.dpws.udp.UdpMessageQueueObserver;
import org.somda.sdc.dpws.udp.UdpMessageQueueServiceImpl;
import org.somda.sdc.dpws.udp.UdpMessageReceiverCallback;

class UdpMessageQueueServiceTest
extends DpwsTest {
    private UdpMessageQueueServiceImpl udpMsgQueue;
    private byte[] actualMessage;
    private Condition condition;
    private Lock lock;

    UdpMessageQueueServiceTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.udpMsgQueue = (UdpMessageQueueServiceImpl)this.getInjector().getInstance(UdpMessageQueueServiceImpl.class);
        UdpBindingServiceMock udpBindingServiceMock = new UdpBindingServiceMock();
        this.udpMsgQueue.setUdpBinding((UdpBindingService)udpBindingServiceMock);
        udpBindingServiceMock.setMessageReceiver((UdpMessageReceiverCallback)this.udpMsgQueue);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.actualMessage = null;
    }

    @Test
    void sendAndReceiveMessage() throws Exception {
        String expectedMsg = "sample";
        this.udpMsgQueue.startAsync().awaitRunning();
        this.udpMsgQueue.registerUdpMessageQueueObserver(new UdpMessageQueueObserver(){

            @Subscribe
            private void receive(UdpMessage msg) {
                UdpMessageQueueServiceTest.this.lock.lock();
                try {
                    UdpMessageQueueServiceTest.this.actualMessage = msg.getData();
                    UdpMessageQueueServiceTest.this.condition.signalAll();
                }
                finally {
                    UdpMessageQueueServiceTest.this.lock.unlock();
                }
            }
        });
        UdpMessage msg = new UdpMessage(expectedMsg.getBytes(), expectedMsg.length());
        this.udpMsgQueue.sendMessage(msg);
        this.lock.lock();
        try {
            if (this.actualMessage == null) {
                this.condition.await(1L, TimeUnit.HOURS);
            }
            MatcherAssert.assertThat((Object)this.actualMessage, (Matcher)Matchers.is((Matcher)Matchers.notNullValue(null)));
            MatcherAssert.assertThat((Object)this.actualMessage, (Matcher)Matchers.is((Object)expectedMsg.getBytes()));
        }
        finally {
            this.lock.unlock();
        }
    }
}

