/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogSink;
import org.somda.sdc.dpws.soap.CommunicationContext;

public class CommunicationLogImpl
implements CommunicationLog {
    private static final Logger LOG = LogManager.getLogger(CommunicationLogImpl.class);
    private final CommunicationLogSink logSink;
    private final Logger instanceLogger;

    @Inject
    public CommunicationLogImpl(CommunicationLogSink sink, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.logSink = sink;
    }

    public TeeOutputStream logMessage(CommunicationLog.Direction direction, CommunicationLog.TransportType transportType, CommunicationLog.MessageType messageType, CommunicationContext communicationContext, OutputStream message) {
        OutputStream logFile = this.logSink.createTargetStream(transportType, direction, messageType, communicationContext);
        return new TeeOutputStream(message, logFile);
    }

    @Override
    public OutputStream logMessage(CommunicationLog.Direction direction, CommunicationLog.TransportType transportType, CommunicationLog.MessageType messageType, CommunicationContext communicationContext) {
        return this.logSink.createTargetStream(transportType, direction, messageType, communicationContext);
    }

    @Override
    public InputStream logMessage(CommunicationLog.Direction direction, CommunicationLog.TransportType transportType, CommunicationLog.MessageType messageType, CommunicationContext communicationContext, InputStream message) {
        return this.writeLogFile(transportType, direction, messageType, communicationContext, message);
    }

    private InputStream writeLogFile(CommunicationLog.TransportType transportType, CommunicationLog.Direction direction, CommunicationLog.MessageType messageType, CommunicationContext communicationContext, InputStream inputStream) {
        try {
            byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
            try (OutputStream targetStream = this.logSink.createTargetStream(transportType, direction, messageType, communicationContext);){
                new ByteArrayInputStream(bytes).transferTo(targetStream);
            }
            return new ByteArrayInputStream(bytes);
        }
        catch (IOException e) {
            this.instanceLogger.warn("Could not write to communication log file", (Throwable)e);
            return inputStream;
        }
    }
}

