/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.client.helper;

import com.google.common.eventbus.Subscribe;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.io.ByteArrayInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.soap.MarshallingService;
import org.somda.sdc.dpws.soap.NotificationSink;
import org.somda.sdc.dpws.soap.SoapDebug;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.udp.UdpMessage;
import org.somda.sdc.dpws.udp.UdpMessageQueueObserver;

public class DiscoveryClientUdpProcessor
implements UdpMessageQueueObserver {
    private static final Logger LOG = LogManager.getLogger(DiscoveryClientUdpProcessor.class);
    private final MarshallingService marshallingService;
    private final NotificationSink notificationSink;
    private final Logger instanceLogger;

    @AssistedInject
    DiscoveryClientUdpProcessor(@Assisted NotificationSink notificationSink, MarshallingService marshallingService, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.notificationSink = notificationSink;
        this.marshallingService = marshallingService;
    }

    @Subscribe
    private void receiveUdpMessage(UdpMessage msg) {
        SoapMessage notification;
        try {
            notification = this.marshallingService.unmarshal(new ByteArrayInputStream(msg.getData(), 0, msg.getLength()));
        }
        catch (MarshallingException e) {
            this.instanceLogger.warn("Incoming UDP message could not be unmarshalled. Message Bytes: {}", (Object)msg);
            return;
        }
        this.instanceLogger.debug("Incoming SOAP/UDP message: {}", new Supplier[]{() -> SoapDebug.get(notification)});
        this.notificationSink.receiveNotification(notification, msg.getCommunicationContext());
    }
}

