/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.crypto;

import com.google.inject.Inject;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.dpws.crypto.CryptoSettings;

public class CryptoConfigurator {
    private static final Logger LOG = LogManager.getLogger(CryptoConfigurator.class);

    @Inject
    CryptoConfigurator() {
    }

    public SSLContext createSslContextFromCryptoConfig(CryptoSettings cryptoSettings) throws KeyStoreException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        if (!cryptoSettings.getKeyStoreStream().isPresent()) {
            throw new IOException("Expected key store, but none found");
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(cryptoSettings.getKeyStoreStream().get(), cryptoSettings.getKeyStorePassword().toCharArray());
        sslContextBuilder.loadKeyMaterial(ks, cryptoSettings.getKeyStorePassword().toCharArray());
        if (!cryptoSettings.getTrustStoreStream().isPresent()) {
            throw new IOException("Expected trust store, but none found");
        }
        KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
        ts.load(cryptoSettings.getTrustStoreStream().get(), cryptoSettings.getTrustStorePassword().toCharArray());
        sslContextBuilder.loadTrustMaterial(ts, null);
        return sslContextBuilder.build();
    }

    public List<X509Certificate> getCertificates(@Nullable CryptoSettings cryptoSettings) {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        if (cryptoSettings == null) {
            return certificates;
        }
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            if (!cryptoSettings.getKeyStoreStream().isPresent()) {
                return certificates;
            }
            ks.load(cryptoSettings.getKeyStoreStream().get(), cryptoSettings.getKeyStorePassword().toCharArray());
            Iterator<String> aliases = ks.aliases().asIterator();
            while (aliases.hasNext()) {
                Certificate cert = ks.getCertificate(aliases.next());
                if (!(cert instanceof X509Certificate)) continue;
                certificates.add((X509Certificate)cert);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOG.error(String.format("Error retrieving certificates from keystore %s", e));
        }
        return certificates;
    }

    public SSLContext createSslContextFromSystemProperties() {
        return SSLContexts.createSystemDefault();
    }
}

