/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.device;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.dpws.device.EventSourceAccess;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.wseventing.EventSource;
import org.somda.sdc.dpws.soap.wseventing.SubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.model.WsEventingStatus;

public abstract class WebService
extends AbstractIdleService
implements EventSourceAccess,
Interceptor {
    private static final Logger LOG = LogManager.getLogger(WebService.class);
    private EventSource eventSource = new EventSource(){

        public Service startAsync() {
            return this;
        }

        public boolean isRunning() {
            return false;
        }

        public Service.State state() {
            return null;
        }

        public Service stopAsync() {
            return this;
        }

        public void awaitRunning() {
        }

        public void awaitRunning(long l, TimeUnit timeUnit) {
        }

        public void awaitTerminated() {
        }

        public void awaitTerminated(long l, TimeUnit timeUnit) {
        }

        public Throwable failureCause() {
            return null;
        }

        public void addListener(Service.Listener listener, Executor executor) {
        }

        @Override
        public void sendNotification(String action, Object payload) {
            LOG.info("No handler for notifications configured yet. Skip sending notification with action: {}", (Object)action);
        }

        @Override
        public void subscriptionEndToAll(WsEventingStatus status) {
            LOG.info("No handler for subscriptionEndToAll configured yet. Skip sending subscriptionEndToAll with status: {}", (Object)status.getUri());
        }

        @Override
        public Map<String, SubscriptionManager> getActiveSubscriptions() {
            LOG.info("No handler for getActiveSubscriptions configured yet. Returning an empty Map instead.");
            return Map.of();
        }
    };

    protected WebService() {
    }

    @Override
    public void sendNotification(String action, Object payload) {
        this.eventSource.sendNotification(action, payload);
    }

    @Override
    public void subscriptionEndToAll(WsEventingStatus status) {
        this.eventSource.subscriptionEndToAll(status);
    }

    void setEventSource(EventSource eventSource) {
        this.eventSource = eventSource;
    }

    protected void startUp() {
        this.eventSource.startAsync().awaitRunning();
    }

    protected void shutDown() {
        this.eventSource.stopAsync().awaitTerminated();
    }
}

