/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.jetty;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.OptionalSslConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.crypto.CryptoConfigurator;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.http.HttpHandler;
import org.somda.sdc.dpws.http.HttpServerRegistry;
import org.somda.sdc.dpws.http.HttpUriBuilder;
import org.somda.sdc.dpws.http.jetty.CommunicationLogHandlerWrapper;
import org.somda.sdc.dpws.http.jetty.JettyHttpServerHandler;
import org.somda.sdc.dpws.http.jetty.factory.JettyHttpServerHandlerFactory;

public class JettyHttpServerRegistry
extends AbstractIdleService
implements HttpServerRegistry {
    private static final Logger LOG = LogManager.getLogger(JettyHttpServerRegistry.class);
    private JettyHttpServerHandlerFactory jettyHttpServerHandlerFactory;
    private final String frameworkIdentifier;
    private final Logger instanceLogger;
    private final CommunicationLog communicationLog;
    private final Map<String, Server> serverRegistry;
    private final Map<String, JettyHttpServerHandler> handlerRegistry;
    private final Map<String, ContextHandler> contextWrapperRegistry;
    private final Map<Server, ContextHandlerCollection> contextHandlerMap;
    private final Lock registryLock;
    private final HttpUriBuilder uriBuilder;
    private final boolean enableGzipCompression;
    private final int minCompressionSize;
    private final String[] tlsProtocols;
    private final String[] enabledCiphers;
    private final HostnameVerifier hostnameVerifier;
    private final boolean enableHttp;
    private final boolean enableHttps;
    private final Duration connectionTimeout;
    private SSLContext sslContext;

    @Inject
    JettyHttpServerRegistry(HttpUriBuilder uriBuilder, CryptoConfigurator cryptoConfigurator, @Nullable @Named(value="Dpws.Crypto.Settings") CryptoSettings cryptoSettings, JettyHttpServerHandlerFactory jettyHttpServerHandlerFactory, @Named(value="Dpws.GzipCompression") boolean enableGzipCompression, @Named(value="Dpws.GzipCompressionMinSize") int minCompressionSize, @Named(value="Dpws.Crypto.TlsEnabledVersions") String[] tlsProtocols, @Named(value="Dpws.Crypto.TlsEnabledCiphers") String[] enabledCiphers, @Named(value="Dpws.Crypto.DeviceHostnameVerifier") HostnameVerifier hostnameVerifier, @Named(value="Dpws.EnableHttps") boolean enableHttps, @Named(value="Dpws.EnableHttp") boolean enableHttp, @Named(value="Dpws.HttpServerConnectionTimeout") Duration connectionTimeout, CommunicationLog communicationLog, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.frameworkIdentifier = frameworkIdentifier;
        this.uriBuilder = uriBuilder;
        this.jettyHttpServerHandlerFactory = jettyHttpServerHandlerFactory;
        this.enableGzipCompression = enableGzipCompression;
        this.minCompressionSize = minCompressionSize;
        this.tlsProtocols = tlsProtocols;
        this.enabledCiphers = enabledCiphers;
        this.hostnameVerifier = hostnameVerifier;
        this.communicationLog = communicationLog;
        this.enableHttps = enableHttps;
        this.enableHttp = enableHttp;
        this.connectionTimeout = connectionTimeout;
        this.serverRegistry = new HashMap<String, Server>();
        this.handlerRegistry = new HashMap<String, JettyHttpServerHandler>();
        this.contextHandlerMap = new HashMap<Server, ContextHandlerCollection>();
        this.contextWrapperRegistry = new HashMap<String, ContextHandler>();
        this.registryLock = new ReentrantLock();
        this.configureSsl(cryptoConfigurator, cryptoSettings);
        if (!this.enableHttp && !this.enableHttps) {
            throw new RuntimeException("Http and https are disabled, cannot continue");
        }
    }

    protected void startUp() throws Exception {
        this.instanceLogger.info("{} is running", (Object)this.getClass().getSimpleName());
    }

    protected void shutDown() throws Exception {
        this.instanceLogger.info("Shut down running HTTP servers");
        this.registryLock.lock();
        try {
            this.serverRegistry.forEach((uri, server) -> {
                try {
                    server.stop();
                    this.instanceLogger.info("Shut down HTTP server at {}", uri);
                    ContextHandlerCollection contextHandlerCollection = this.contextHandlerMap.remove(server);
                    if (contextHandlerCollection != null) {
                        contextHandlerCollection.stop();
                        this.instanceLogger.info("Shut down HTTP context handler collection at {}", uri);
                    }
                    this.handlerRegistry.forEach((handlerUri, handler) -> {
                        try {
                            handler.stop();
                        }
                        catch (Exception e) {
                            this.instanceLogger.warn("HTTP handler could not be stopped properly", (Throwable)e);
                        }
                    });
                    this.handlerRegistry.clear();
                    this.contextWrapperRegistry.forEach((contextPath, wrapper) -> {
                        try {
                            wrapper.stop();
                        }
                        catch (Exception e) {
                            this.instanceLogger.warn("HTTP handler wrapper could not be stopped properly", (Throwable)e);
                        }
                    });
                    this.contextWrapperRegistry.clear();
                }
                catch (Exception e) {
                    this.instanceLogger.warn("HTTP server could not be stopped properly", (Throwable)e);
                }
            });
            this.serverRegistry.clear();
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String initHttpServer(String schemeAndAuthority) {
        this.registryLock.lock();
        try {
            Server server = this.makeHttpServer(schemeAndAuthority);
            String uriString = server.getURI().toString();
            if (uriString.endsWith("/")) {
                uriString = uriString.substring(0, uriString.length() - 1);
            }
            URI serverUri = URI.create(uriString);
            URI requestedUri = URI.create(schemeAndAuthority);
            if (!serverUri.getScheme().equals(requestedUri.getScheme())) {
                try {
                    serverUri = this.replaceScheme(serverUri, requestedUri.getScheme());
                }
                catch (URISyntaxException e) {
                    this.instanceLogger.error("Unexpected error while creating server uri value with uri {} and new scheme {} value: {}", (Object)serverUri, (Object)requestedUri.getScheme(), (Object)e.getMessage());
                    this.instanceLogger.trace("Unexpected error while creating server uri value with uri {} and new scheme {} value", (Object)serverUri, (Object)requestedUri.getScheme(), (Object)e);
                }
            }
            String string = serverUri.toString();
            return string;
        }
        finally {
            this.registryLock.unlock();
        }
    }

    @Override
    public String registerContext(String schemeAndAuthority, String contextPath, HttpHandler handler) {
        return this.registerContext(schemeAndAuthority, contextPath, "application/soap+xml", handler);
    }

    @Override
    public String registerContext(String schemeAndAuthority, String contextPath, String mediaType, HttpHandler handler) {
        if (!contextPath.startsWith("/")) {
            throw new RuntimeException(String.format("Context path needs to start with a slash, but is %s", contextPath));
        }
        this.registryLock.lock();
        try {
            String mapKey;
            Server server = this.makeHttpServer(schemeAndAuthority);
            try {
                mapKey = this.makeMapKey(server.getURI().toString(), contextPath);
            }
            catch (UnknownHostException e) {
                this.instanceLogger.error("Unexpected URI conversion error", (Throwable)e);
                throw new RuntimeException("Unexpected URI conversion error");
            }
            URI mapKeyUri = URI.create(mapKey);
            JettyHttpServerHandler endpointHandler = this.jettyHttpServerHandlerFactory.create(mediaType, handler);
            ContextHandler context = new ContextHandler(contextPath);
            context.setHandler((Handler)endpointHandler);
            context.setAllowNullPathInfo(true);
            this.handlerRegistry.put(mapKeyUri.toString(), endpointHandler);
            this.contextWrapperRegistry.put(contextPath, context);
            ContextHandlerCollection contextHandler = this.contextHandlerMap.get(server);
            contextHandler.addHandler((Handler)context);
            context.start();
            URI contextUri = this.replaceScheme(mapKeyUri, URI.create(schemeAndAuthority).getScheme());
            String string = contextUri.toString();
            return string;
        }
        catch (Exception e) {
            this.instanceLogger.error("Registering context {} failed.", (Object)contextPath, (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.registryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterContext(String schemeAndAuthority, String contextPath) {
        this.registryLock.lock();
        try {
            String httpHandlerRegistryKey;
            String serverRegistryKey;
            try {
                serverRegistryKey = this.makeMapKey(schemeAndAuthority);
                httpHandlerRegistryKey = this.makeMapKey(schemeAndAuthority, contextPath);
            }
            catch (UnknownHostException e) {
                this.instanceLogger.error("Unexpected URI conversion error", (Throwable)e);
                throw new RuntimeException("Unexpected URI conversion error");
            }
            Optional.ofNullable(this.serverRegistry.get(serverRegistryKey)).ifPresent(httpServer -> {
                Optional.ofNullable(this.handlerRegistry.get(httpHandlerRegistryKey)).ifPresent(handlerWrapper -> {
                    this.instanceLogger.info("Unregister context path '{}'", (Object)contextPath);
                    this.handlerRegistry.remove(httpHandlerRegistryKey);
                    ContextHandler removedHandler = this.contextWrapperRegistry.remove(contextPath);
                    ContextHandlerCollection servletContextHandler = this.contextHandlerMap.get(httpServer);
                    servletContextHandler.removeHandler((Handler)removedHandler);
                });
                if (this.handlerRegistry.isEmpty()) {
                    this.instanceLogger.info("No further HTTP handlers active. Shutdown HTTP server at '{}'", (Object)schemeAndAuthority);
                    try {
                        httpServer.stop();
                    }
                    catch (Exception e) {
                        this.instanceLogger.error("Could not stop HTTP server", (Throwable)e);
                    }
                    this.serverRegistry.remove(serverRegistryKey);
                }
            });
        }
        finally {
            this.registryLock.unlock();
        }
    }

    private void configureSsl(CryptoConfigurator cryptoConfigurator, @Nullable CryptoSettings cryptoSettings) {
        if (cryptoSettings == null) {
            this.sslContext = null;
            return;
        }
        try {
            this.sslContext = cryptoConfigurator.createSslContextFromCryptoConfig(cryptoSettings);
        }
        catch (IOException | IllegalArgumentException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            this.instanceLogger.warn("Could not read server crypto config, fallback to system properties");
            this.sslContext = cryptoConfigurator.createSslContextFromSystemProperties();
        }
    }

    private Server makeHttpServer(String uri) {
        String mapKey;
        try {
            mapKey = this.makeMapKey(uri);
        }
        catch (UnknownHostException e) {
            this.instanceLogger.error("Unexpected URI conversion error", (Throwable)e);
            throw new RuntimeException("Unexpected URI conversion error");
        }
        Optional<Server> oldServer = Optional.ofNullable(this.serverRegistry.get(mapKey));
        if (oldServer.isPresent()) {
            this.instanceLogger.debug("Re-use running HTTP server from URI: {}", (Object)oldServer.get().getURI().getHost());
            return oldServer.get();
        }
        this.instanceLogger.debug("Init new HTTP server from URI: {}", (Object)uri);
        Server httpServer = this.createHttpServer(URI.create(uri));
        try {
            httpServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String serverUri = httpServer.getURI().toString();
        try {
            this.serverRegistry.put(this.makeMapKey(serverUri), httpServer);
        }
        catch (UnknownHostException e) {
            this.instanceLogger.error("Unexpected URI conversion error", (Throwable)e);
            throw new RuntimeException("Unexpected URI conversion error");
        }
        this.instanceLogger.debug("New HTTP server initialized: {}", (Object)uri);
        return httpServer;
    }

    private Server createHttpServer(URI uri) {
        this.instanceLogger.info("Setup HTTP server for address '{}'", (Object)uri);
        if (!this.isSupportedScheme(uri)) {
            throw new RuntimeException(String.format("HTTP server setup failed. Unsupported scheme: %s", uri.getScheme()));
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme(HttpScheme.HTTPS.asString());
        httpConfig.setHttpCompliance(HttpCompliance.RFC2616);
        Server server = new Server(new InetSocketAddress(uri.getHost(), uri.getPort()));
        ContextHandlerCollection context = new ContextHandlerCollection();
        server.setHandler((Handler)context);
        this.contextHandlerMap.put(server, context);
        CommunicationLogHandlerWrapper commlogHandler = new CommunicationLogHandlerWrapper(this.communicationLog, this.frameworkIdentifier);
        commlogHandler.setHandler(server.getHandler());
        server.setHandler((Handler)commlogHandler);
        if (this.enableGzipCompression) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setIncludedMethods(new String[]{HttpMethod.PUT.asString(), HttpMethod.POST.asString(), HttpMethod.GET.asString()});
            gzipHandler.setInflateBufferSize(2048);
            gzipHandler.setHandler(server.getHandler());
            gzipHandler.setMinGzipSize(this.minCompressionSize);
            gzipHandler.setIncludedMimeTypes(new String[]{"text/plain", "text/html", "application/soap+xml", "text/xml"});
            server.setHandler((Handler)gzipHandler);
        }
        if (this.sslContext != null && this.enableHttps) {
            SslContextFactory.Server contextFactory = new SslContextFactory.Server();
            contextFactory.setSslContext(this.sslContext);
            contextFactory.setNeedClientAuth(true);
            this.instanceLogger.debug("Enabled protocols: {}", new Supplier[]{() -> List.of(this.tlsProtocols)});
            contextFactory.setExcludeProtocols(new String[0]);
            contextFactory.setIncludeProtocols(this.tlsProtocols);
            contextFactory.setExcludeCipherSuites(new String[0]);
            contextFactory.setIncludeCipherSuites(this.enabledCiphers);
            SecureRequestCustomizer src = new SecureRequestCustomizer();
            src.setSniHostCheck(false);
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            HttpConfiguration.Customizer clientVerifier = new HttpConfiguration.Customizer(){

                public void customize(Connector connector, HttpConfiguration channelConfig, Request request) {
                    long numRequest = request.getHttpChannel().getRequests();
                    if (numRequest != 1L) {
                        JettyHttpServerRegistry.this.instanceLogger.debug("Connection already verified");
                        return;
                    }
                    EndPoint endp = request.getHttpChannel().getEndPoint();
                    if (endp instanceof SslConnection.DecryptedEndPoint) {
                        SslConnection.DecryptedEndPoint sslEndp = (SslConnection.DecryptedEndPoint)endp;
                        SslConnection sslConnection = sslEndp.getSslConnection();
                        SSLEngine sslEngine = sslConnection.getSSLEngine();
                        SSLSession session = sslEngine.getSession();
                        endp.getLocalAddress().getHostName();
                        if (!JettyHttpServerRegistry.this.hostnameVerifier.verify(sslEndp.getLocalAddress().getHostName(), session)) {
                            JettyHttpServerRegistry.this.instanceLogger.debug("HostnameVerifier has filtered request, marking request as handled and aborting request");
                            request.setHandled(true);
                            request.getHttpChannel().abort((Throwable)new Exception("HostnameVerifier has rejected request"));
                        }
                    }
                }
            };
            httpsConfig.addCustomizer(clientVerifier);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)src);
            SslConnectionFactory connectionFactory = new SslConnectionFactory(contextFactory, HttpVersion.HTTP_1_1.asString());
            HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpsConfig);
            ServerConnector httpsConnector = this.enableHttp ? new ServerConnector(server, new ConnectionFactory[]{new OptionalSslConnectionFactory(connectionFactory, HttpVersion.HTTP_1_1.asString()), connectionFactory, httpConnectionFactory}) : new ServerConnector(server, new ConnectionFactory[]{connectionFactory, httpConnectionFactory});
            httpsConnector.setIdleTimeout(this.connectionTimeout.toMillis());
            httpsConnector.setHost(uri.getHost());
            httpsConnector.setPort(uri.getPort());
            server.setConnectors(new Connector[]{httpsConnector});
        }
        return server;
    }

    private String makeMapKey(String uri) throws UnknownHostException {
        URI parsedUri = URI.create(uri);
        InetAddress address = InetAddress.getByName(parsedUri.getHost());
        return this.uriBuilder.buildUri("httpx", address.getHostAddress(), parsedUri.getPort());
    }

    private String makeMapKey(String uri, String contextPath) throws UnknownHostException {
        return this.makeMapKey(uri) + contextPath;
    }

    private URI replaceScheme(URI baseUri, String scheme) throws URISyntaxException {
        return new URI(scheme, baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment());
    }

    private boolean isSupportedScheme(URI address) {
        return this.enableHttp && HttpScheme.HTTP.asString().equalsIgnoreCase(address.getScheme()) || this.enableHttps && HttpScheme.HTTPS.asString().equalsIgnoreCase(address.getScheme());
    }
}

