/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.service;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.somda.sdc.common.util.ObjectUtil;
import org.somda.sdc.dpws.device.WebService;
import org.somda.sdc.dpws.model.HostedServiceType;
import org.somda.sdc.dpws.model.ObjectFactory;
import org.somda.sdc.dpws.service.HostedService;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;

public class HostedServiceImpl
implements HostedService {
    private final String serviceId;
    private final List<QName> types;
    private final List<EndpointReferenceType> eprs;
    private final WebService webService;
    private final byte[] wsdlDocument;
    private final ObjectFactory dpwsFactory;
    private final ObjectUtil objectUtil;

    @AssistedInject
    HostedServiceImpl(@Assisted String serviceId, @Assisted List<QName> types, @Assisted List<String> eprAddresses, @Assisted WebService webService, @Assisted byte[] wsdlDocument, ObjectFactory dpwsFactory, ObjectUtil objectUtil, WsAddressingUtil wsaUtil) {
        this.serviceId = serviceId;
        this.types = types;
        this.eprs = eprAddresses.stream().map(wsaUtil::createEprWithAddress).collect(Collectors.toList());
        this.webService = webService;
        this.wsdlDocument = wsdlDocument;
        this.dpwsFactory = dpwsFactory;
        this.objectUtil = objectUtil;
    }

    @AssistedInject
    HostedServiceImpl(@Assisted String serviceId, @Assisted List<QName> types, @Assisted WebService webService, @Assisted byte[] wsdlDocument, ObjectFactory dpwsFactory, ObjectUtil objectUtil, WsAddressingUtil wsaUtil) {
        this(serviceId, types, new ArrayList<String>(), webService, wsdlDocument, dpwsFactory, objectUtil, wsaUtil);
    }

    @Override
    public HostedServiceType getType() {
        HostedServiceType hst = this.dpwsFactory.createHostedServiceType();
        hst.setServiceId(this.serviceId);
        hst.setEndpointReference((List)this.objectUtil.deepCopy(this.eprs));
        hst.setTypes(new ArrayList<QName>(this.types));
        return hst;
    }

    @Override
    public WebService getWebService() {
        return this.webService;
    }

    @Override
    public byte[] getWsdlDocument() {
        return this.wsdlDocument;
    }
}

