/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.NotificationSink;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.InterceptorRegistry;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.interception.ServerDispatcher;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingServerInterceptor;

public class NotificationSinkImpl
implements NotificationSink {
    private static final Logger LOG = LogManager.getLogger(NotificationSinkImpl.class);
    private final InterceptorRegistry interceptorRegistry;
    private final ServerDispatcher serverDispatcher;
    private final Logger instanceLogger;

    @Inject
    NotificationSinkImpl(@Assisted WsAddressingServerInterceptor wsaServerInterceptor, ServerDispatcher serverDispatcher, InterceptorRegistry interceptorRegistry, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.serverDispatcher = serverDispatcher;
        this.interceptorRegistry = interceptorRegistry;
        this.register(wsaServerInterceptor);
    }

    @Override
    public void register(Interceptor interceptor) {
        this.interceptorRegistry.addInterceptor(interceptor);
    }

    @Override
    public void receiveNotification(SoapMessage notification, CommunicationContext communicationContext) {
        NotificationObject nObj = new NotificationObject(notification, communicationContext);
        try {
            this.serverDispatcher.invokeDispatcher(Direction.NOTIFICATION, this.interceptorRegistry, notification, nObj);
        }
        catch (SoapFaultException e) {
            this.instanceLogger.debug("Caught SoapFaultException on notification is dropped. Message: {}", (Object)e.getMessage());
        }
    }
}

