/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.JaxbUtil;
import org.somda.sdc.common.util.UriUtil;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.ReferenceParametersType;
import org.w3c.dom.Element;

public class SoapUtil {
    private static final Logger LOG = LogManager.getLogger(SoapUtil.class);
    private final WsAddressingUtil wsaUtil;
    private final SoapMessageFactory soapMessageFactory;
    private final EnvelopeFactory envelopeFactory;
    private final JaxbUtil jaxbUtil;
    private final Logger instanceLogger;

    @Inject
    SoapUtil(WsAddressingUtil wsaUtil, SoapMessageFactory soapMessageFactory, EnvelopeFactory envelopeFactory, JaxbUtil jaxbUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.wsaUtil = wsaUtil;
        this.soapMessageFactory = soapMessageFactory;
        this.envelopeFactory = envelopeFactory;
        this.jaxbUtil = jaxbUtil;
    }

    public <T> void setBody(T element, SoapMessage dest) {
        dest.getOriginalEnvelope().getBody().getAny().clear();
        dest.getOriginalEnvelope().getBody().getAny().add(element);
    }

    public <T> Optional<T> getBody(SoapMessage src, Class<T> destType) {
        return this.jaxbUtil.extractFirstElementFromAny(src.getOriginalEnvelope().getBody().getAny(), destType);
    }

    public String createUriFromUuid(UUID uuid) {
        return UriUtil.createUuid((UUID)uuid);
    }

    public UUID createUuidFromUri(String uri) {
        return UUID.fromString(uri.substring("urn:uuid:".length()));
    }

    public String createRandomUuidUri() {
        return this.createUriFromUuid(UUID.randomUUID());
    }

    public void setWsaAction(SoapMessage response, String action) {
        response.getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType(action));
    }

    public SoapMessage createMessage() {
        return this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope());
    }

    public SoapMessage createMessage(Envelope envelope) {
        return this.soapMessageFactory.createSoapMessage(envelope);
    }

    public SoapMessage createMessage(String wsaAction) {
        SoapMessage message = this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope());
        message.getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType(wsaAction));
        return message;
    }

    public SoapMessage createMessage(String wsaAction, @Nullable Object firstBodyElement) {
        SoapMessage message = this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope(firstBodyElement));
        message.getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType(wsaAction));
        return message;
    }

    public SoapMessage createMessage(String wsaAction, String wsaTo) {
        SoapMessage message = this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope());
        message.getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType(wsaAction));
        message.getWsAddressingHeader().setTo(this.wsaUtil.createAttributedURIType(wsaTo));
        return message;
    }

    public SoapMessage createMessage(String wsaAction, String wsaTo, @Nullable Object firstBodyElement) {
        SoapMessage message = this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope(firstBodyElement));
        message.getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType(wsaAction));
        message.getWsAddressingHeader().setTo(this.wsaUtil.createAttributedURIType(wsaTo));
        return message;
    }

    public SoapMessage createMessage(String wsaAction, String wsaTo, @Nullable Object firstBodyElement, @Nullable ReferenceParametersType referenceParameters) {
        SoapMessage message = this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope(firstBodyElement));
        message.getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType(wsaAction));
        message.getWsAddressingHeader().setTo(this.wsaUtil.createAttributedURIType(wsaTo));
        if (referenceParameters != null) {
            List<Element> actualParameters = referenceParameters.getAny().stream().filter(obj -> {
                boolean correctType = obj instanceof Element;
                if (!correctType) {
                    this.instanceLogger.warn("Reference parameter couldn't be attached to outgoing message, wrong type! Type was {}", (Object)obj.getClass().getSimpleName());
                }
                return correctType;
            }).map(obj -> (Element)((Element)obj).cloneNode(true)).collect(Collectors.toList());
            message.getWsAddressingHeader().setMappedReferenceParameters(actualParameters);
        }
        return message;
    }
}

