/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing;

import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.NetworkJobThreadPool;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.factory.NotificationSourceFactory;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.helper.SubscriptionManagerBase;
import org.somda.sdc.dpws.soap.wseventing.model.Notification;

public class SourceSubscriptionManagerImpl
extends AbstractExecutionThreadService
implements SourceSubscriptionManager {
    private static final Logger LOG = LogManager.getLogger(SourceSubscriptionManagerImpl.class);
    private final BlockingQueue<QueueItem> notificationQueue;
    private final SubscriptionManagerBase delegate;
    private final NotificationSourceFactory notificationSourceFactory;
    private final TransportBindingFactory transportBindingFactory;
    private final WsAddressingUtil wsaUtil;
    private final ExecutorWrapperService<ListeningExecutorService> networkJobExecutor;
    private final Logger instanceLogger;
    private NotificationSource notifyToSender;
    private NotificationSource endToSender;
    private String subscriptionId;
    private String notifyToUri;

    @AssistedInject
    SourceSubscriptionManagerImpl(@Assisted(value="SubscriptionManager") EndpointReferenceType subscriptionManagerEpr, @Assisted Duration expires, @Assisted(value="NotifyTo") EndpointReferenceType notifyTo, @Assisted(value="EndTo") @Nullable EndpointReferenceType endTo, @Assisted(value="SubscriptionId") String subscriptionId, @Assisted(value="Actions") Collection<String> actions, @Named(value="SoapConfig.NotificationQueueCapacity") Integer notificationQueueCapacity, NotificationSourceFactory notificationSourceFactory, TransportBindingFactory transportBindingFactory, WsAddressingUtil wsaUtil, @NetworkJobThreadPool ExecutorWrapperService<ListeningExecutorService> networkJobExecutor, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.notificationSourceFactory = notificationSourceFactory;
        this.transportBindingFactory = transportBindingFactory;
        this.wsaUtil = wsaUtil;
        this.networkJobExecutor = networkJobExecutor;
        this.subscriptionId = UUID.randomUUID().toString();
        this.delegate = new SubscriptionManagerBase(notifyTo, endTo, subscriptionId, expires, subscriptionManagerEpr, actions);
        this.notificationQueue = new ArrayBlockingQueue<QueueItem>(notificationQueueCapacity);
        this.notifyToSender = null;
        this.endToSender = null;
        this.notifyToUri = "";
    }

    @Override
    public String getSubscriptionId() {
        return this.delegate.getSubscriptionId();
    }

    @Override
    public LocalDateTime getExpiresTimeout() {
        return this.delegate.getExpiresTimeout();
    }

    @Override
    public EndpointReferenceType getNotifyTo() {
        return this.delegate.getNotifyTo();
    }

    @Override
    public Optional<EndpointReferenceType> getEndTo() {
        return this.delegate.getEndTo();
    }

    @Override
    public Duration getExpires() {
        return this.delegate.getExpires();
    }

    @Override
    public EndpointReferenceType getSubscriptionManagerEpr() {
        return this.delegate.getSubscriptionManagerEpr();
    }

    @Override
    public Collection<String> getActions() {
        return this.delegate.getActions();
    }

    @Override
    public void renew(Duration expires) {
        this.delegate.renew(expires);
    }

    @Override
    public void offerNotification(Notification notification) {
        if (!this.isRunning()) {
            return;
        }
        if (!this.notificationQueue.offer(new QueueItem(notification))) {
            this.stopAsync().awaitTerminated();
        }
    }

    @Override
    public void sendToEndTo(SoapMessage endToMessage) {
        if (this.endToSender == null) {
            return;
        }
        ((ListeningExecutorService)this.networkJobExecutor.get()).submit(() -> {
            try {
                this.endToSender.sendNotification(endToMessage);
            }
            catch (Exception e) {
                this.instanceLogger.info("End-to message could not be delivered.", (Throwable)e);
            }
        });
    }

    protected void startUp() {
        Optional<String> addressUriAsString;
        this.notifyToUri = this.wsaUtil.getAddressUri(this.getNotifyTo()).orElseThrow(() -> new RuntimeException("Invalid notify-to EPR"));
        this.notifyToSender = this.notificationSourceFactory.createNotificationSource(this.transportBindingFactory.createTransportBinding(this.notifyToUri));
        if (this.getEndTo().isPresent() && (addressUriAsString = this.wsaUtil.getAddressUri(this.getEndTo().get())).isPresent()) {
            this.endToSender = this.notificationSourceFactory.createNotificationSource(this.transportBindingFactory.createTransportBinding(this.notifyToUri));
        }
        this.subscriptionId = this.wsaUtil.getAddressUri(this.delegate.getSubscriptionManagerEpr()).orElseThrow(() -> new NoSuchElementException("Subscription manager id could not be resolved"));
        this.instanceLogger.info("Source subscription manager '{}' started. Start delivering notifications to '{}'", (Object)this.subscriptionId, (Object)this.notifyToUri);
    }

    protected void run() {
        try {
            while (true) {
                QueueItem queueItem;
                if ((queueItem = this.notificationQueue.take()) instanceof QueueShutDownItem) {
                    this.instanceLogger.info("Source subscription manager '{}' received stop signal and is about to shut down", (Object)this.subscriptionId);
                    break;
                }
                this.instanceLogger.debug("Sending notification to {} - {}", (Object)this.notifyToUri, (Object)queueItem.getNotification().getPayload());
                this.notifyToSender.sendNotification(queueItem.getNotification().getPayload());
            }
        }
        catch (Exception e) {
            this.instanceLogger.info("Source subscription manager '{}' ended unexpectedly", (Object)this.subscriptionId);
            this.instanceLogger.trace("Source subscription manager '{}' ended unexpectedly", (Object)this.subscriptionId, (Object)e);
        }
    }

    protected void shutDown() {
        this.instanceLogger.info("Source subscription manager '{}' shut down. Delivery to '{}' stopped.", (Object)this.subscriptionId, (Object)this.notifyToUri);
    }

    protected void triggerShutdown() {
        this.notificationQueue.clear();
        this.notificationQueue.offer(new QueueShutDownItem());
    }

    private static class QueueShutDownItem
    extends QueueItem {
        QueueShutDownItem() {
            super(null);
        }
    }

    private static class QueueItem {
        private Notification notification;

        QueueItem(@Nullable Notification notification) {
            this.notification = notification;
        }

        public Notification getNotification() {
            return this.notification;
        }
    }
}

