/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing.helper;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.somda.sdc.common.util.AutoLock;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wseventing.SubscriptionManager;

public class SubscriptionManagerBase
implements SubscriptionManager {
    private final EndpointReferenceType notifyTo;
    private final EndpointReferenceType endTo;
    private final Collection<String> actions;
    private LocalDateTime expiresTimeout;
    private final String subscriptionId;
    private Duration expires;
    private final EndpointReferenceType subscriptionManagerEpr;
    private final Lock expiresLock;

    public SubscriptionManagerBase(EndpointReferenceType notifyTo, @Nullable EndpointReferenceType endTo, String subscriptionId, Duration expires, EndpointReferenceType subscriptionManagerEpr, Collection<String> actions) {
        this.notifyTo = notifyTo;
        this.endTo = endTo;
        this.expiresTimeout = this.calculateTimeout(expires);
        this.subscriptionId = subscriptionId;
        this.expires = expires;
        this.subscriptionManagerEpr = subscriptionManagerEpr;
        this.expiresLock = new ReentrantLock();
        this.actions = actions;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public LocalDateTime getExpiresTimeout() {
        try (AutoLock ignored = AutoLock.lock((Lock)this.expiresLock);){
            LocalDateTime localDateTime = this.expiresTimeout;
            return localDateTime;
        }
    }

    @Override
    public EndpointReferenceType getNotifyTo() {
        return this.notifyTo;
    }

    @Override
    public Optional<EndpointReferenceType> getEndTo() {
        return Optional.ofNullable(this.endTo);
    }

    @Override
    public Duration getExpires() {
        try (AutoLock ignored = AutoLock.lock((Lock)this.expiresLock);){
            Duration duration = this.expires;
            return duration;
        }
    }

    @Override
    public EndpointReferenceType getSubscriptionManagerEpr() {
        return this.subscriptionManagerEpr;
    }

    @Override
    public Collection<String> getActions() {
        return Collections.unmodifiableCollection(this.actions);
    }

    public void renew(Duration expires) {
        try (AutoLock ignored = AutoLock.lock((Lock)this.expiresLock);){
            this.expires = expires;
            this.expiresTimeout = this.calculateTimeout(expires);
        }
    }

    private LocalDateTime calculateTimeout(Duration expires) {
        LocalDateTime t = LocalDateTime.now();
        return t.plus(expires);
    }
}

