/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing.helper;

import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.event.SubscriptionAddedMessage;
import org.somda.sdc.dpws.soap.wseventing.event.SubscriptionRemovedMessage;

public class SubscriptionRegistry {
    private final EventBus eventBus;
    private final Map<String, SourceSubscriptionManager> subscriptionManagers;

    @Inject
    SubscriptionRegistry(EventBus eventBus) {
        this.eventBus = eventBus;
        this.subscriptionManagers = new ConcurrentHashMap<String, SourceSubscriptionManager>();
    }

    public void addSubscription(SourceSubscriptionManager subscriptionManager) {
        this.subscriptionManagers.put(subscriptionManager.getSubscriptionId(), subscriptionManager);
        this.eventBus.post((Object)new SubscriptionAddedMessage(subscriptionManager));
    }

    public Optional<SourceSubscriptionManager> removeSubscription(String subscriptionId) {
        SourceSubscriptionManager removedSub = this.subscriptionManagers.remove(subscriptionId);
        if (removedSub != null) {
            this.eventBus.post((Object)new SubscriptionRemovedMessage(removedSub));
        }
        return Optional.ofNullable(removedSub);
    }

    public Optional<SourceSubscriptionManager> getSubscription(String subscriptionId) {
        return Optional.ofNullable(this.subscriptionManagers.get(subscriptionId));
    }

    public Map<String, SourceSubscriptionManager> getSubscriptions() {
        return new HashMap<String, SourceSubscriptionManager>(this.subscriptionManagers);
    }

    public void registerObserver(Object observer) {
        this.eventBus.register(observer);
    }

    public void unregisterObserver(Object observer) {
        this.eventBus.unregister(observer);
    }
}

