/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpServerUtil {
    private static final Logger LOG = LogManager.getLogger(HttpServerUtil.class);

    public static HttpServer spawnHttpServer(InetSocketAddress addr, HttpHandler httpHandler) throws IOException {
        HttpServer server = HttpServer.create(addr, 0);
        server.createContext("/", httpHandler);
        server.setExecutor(null);
        server.start();
        return server;
    }

    public static class GzipResponseHandler
    implements HttpHandler {
        public static final String TEST_HEADER_KEY = "SDCriTestHeader";
        public static final String TEST_HEADER_VALUE = "anAmazingValue";
        private final byte[] compressedResponse;

        GzipResponseHandler(byte[] response) throws IOException {
            ByteArrayOutputStream responseBais = new ByteArrayOutputStream();
            try (GZIPOutputStream gzos = new GZIPOutputStream(responseBais);){
                gzos.write(response);
            }
            this.compressedResponse = responseBais.toByteArray();
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            Object strings = t.getRequestHeaders().get("Accept-Encoding");
            if (strings.stream().noneMatch(x -> x.contains("gzip"))) {
                LOG.error("No Accept-Encoding with value gzip in request header");
                throw new RuntimeException("No Accept-Encoding with value gzip in request header");
            }
            t.getResponseHeaders().add(TEST_HEADER_KEY, TEST_HEADER_VALUE);
            t.getResponseHeaders().add("Content-Encoding", "gzip");
            t.getResponseHeaders().add("Content-Type", "application/soap+xml");
            t.sendResponseHeaders(200, this.compressedResponse.length);
            OutputStream os = t.getResponseBody();
            os.write(this.compressedResponse);
            os.close();
        }
    }
}

