/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.inject.Inject;
import dpws_test_service.messages._2017._05._10.ObjectFactory;
import dpws_test_service.messages._2017._05._10.TestNotification;
import dpws_test_service.messages._2017._05._10.TestOperationRequest;
import dpws_test_service.messages._2017._05._10.TestOperationResponse;
import org.somda.sdc.dpws.device.WebService;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;

public class DpwsTestService1
extends WebService {
    private final WsAddressingUtil wsaUtil;
    private final SoapUtil soapUtil;
    private final SoapFaultFactory soapFaultFactory;
    private final ObjectFactory objectFactory;
    private TransportInfoCallback transportInfoCallback;

    @Inject
    DpwsTestService1(WsAddressingUtil wsaUtil, SoapUtil soapUtil, SoapFaultFactory soapFaultFactory, ObjectFactory objectFactory) {
        this.wsaUtil = wsaUtil;
        this.soapUtil = soapUtil;
        this.soapFaultFactory = soapFaultFactory;
        this.objectFactory = objectFactory;
        this.transportInfoCallback = null;
    }

    public void sendNotification(TestNotification notificationToSend) throws MarshallingException, TransportException {
        this.sendNotification("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification", notificationToSend);
        this.sendNotification("http://dpws-test-service/2017/05/10/TestPortType2/TestNotification", notificationToSend);
    }

    public void setTransportInfoCallback(TransportInfoCallback transportInfoCallback) {
        this.transportInfoCallback = transportInfoCallback;
    }

    @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestOperationRequest")
    void onTestOperation1(RequestResponseObject rrObj) throws SoapFaultException {
        rrObj.getResponse().getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType("http://dpws-test-service/2017/05/10/TestPortType1/TestOperationResponse"));
        TestOperationRequest req = (TestOperationRequest)this.soapUtil.getBody(rrObj.getRequest(), TestOperationRequest.class).orElseThrow(() -> new SoapFaultException(this.soapFaultFactory.createSenderFault("SOAP body is malformed."), (AttributedURIType)rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
        if (this.transportInfoCallback != null) {
            this.transportInfoCallback.onRequest(rrObj.getCommunicationContext().getTransportInfo());
        }
        TestOperationResponse res = this.objectFactory.createTestOperationResponse();
        res.setResult1(new StringBuilder(req.getParam1()).reverse().toString());
        res.setResult2(req.getParam2() * 2);
        this.soapUtil.setBody((Object)res, rrObj.getResponse());
    }

    @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType2/TestOperationRequest")
    void onTestOperation2(RequestResponseObject rrObj) throws SoapFaultException {
        rrObj.getResponse().getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType("http://dpws-test-service/2017/05/10/TestPortType2/TestOperationResponse"));
        TestOperationRequest req = (TestOperationRequest)this.soapUtil.getBody(rrObj.getRequest(), TestOperationRequest.class).orElseThrow(() -> new SoapFaultException(this.soapFaultFactory.createSenderFault("SOAP body is malformed."), (AttributedURIType)rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
        if (this.transportInfoCallback != null) {
            this.transportInfoCallback.onRequest(rrObj.getCommunicationContext().getTransportInfo());
        }
        TestOperationResponse res = this.objectFactory.createTestOperationResponse();
        res.setResult1(req.getParam1() + req.getParam1());
        res.setResult2(req.getParam2() * 4);
        this.soapUtil.setBody((Object)res, rrObj.getResponse());
    }

    public static interface TransportInfoCallback {
        public void onRequest(TransportInfo var1);
    }
}

