/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.udp;

import com.google.common.util.concurrent.SettableFuture;
import it.org.somda.sdc.dpws.IntegrationTestUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.udp.UdpBindingService;
import org.somda.sdc.dpws.udp.UdpMessage;
import org.somda.sdc.dpws.udp.factory.UdpBindingServiceFactory;
import test.org.somda.common.LoggingTestWatcher;

@ExtendWith(value={LoggingTestWatcher.class})
class UdpBindingServiceImplIT {
    private final IntegrationTestUtil IT = new IntegrationTestUtil();
    private Lock lock;
    private Condition condition;
    private UdpMessage actualMessage;
    private UdpBindingServiceFactory factory;
    private NetworkInterface localhostInterface;

    public UdpBindingServiceImplIT() {
        IntegrationTestUtil.preferIpV4Usage();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.factory = (UdpBindingServiceFactory)this.IT.getInjector().getInstance(UdpBindingServiceFactory.class);
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.localhostInterface = NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSendMulticastMessage() throws Exception {
        byte[] expectedMessage = "SAMPLE".getBytes();
        this.actualMessage = null;
        UdpBindingService receiver = this.factory.createUdpBindingService(this.localhostInterface, InetAddress.getByName("239.255.255.250"), Integer.valueOf(3702), Integer.valueOf(4096));
        Thread t = new Thread(() -> {
            try {
                UdpBindingService sender = this.factory.createUdpBindingService(this.localhostInterface, InetAddress.getByName("239.255.255.250"), Integer.valueOf(3702), Integer.valueOf(4096));
                sender.startAsync().awaitRunning();
                sender.sendMessage(new UdpMessage(expectedMessage, expectedMessage.length));
            }
            catch (Exception e) {
                Assertions.fail();
            }
        });
        receiver.setMessageReceiver(msg -> {
            try {
                this.lock.lock();
                this.actualMessage = msg;
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        });
        receiver.startAsync().awaitRunning();
        t.start();
        try {
            this.lock.lock();
            long tStart = System.currentTimeMillis();
            for (long wait = 10000L; wait > 0L && this.actualMessage == null; wait -= System.currentTimeMillis() - tStart) {
                this.condition.await(wait, TimeUnit.MILLISECONDS);
            }
            Assertions.assertNotNull((Object)this.actualMessage);
            byte[] actualBytes = Arrays.copyOf(this.actualMessage.getData(), this.actualMessage.getLength());
            Assertions.assertEquals((Object)Arrays.toString(expectedMessage), (Object)Arrays.toString(actualBytes));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Test
    void testSendMulticastMessageWithReply() throws Exception {
        String expectedRequestStr = "REQUEST";
        String expectedResponseStr = "RESPONSE";
        byte[] expectedRequestBytes = "REQUEST".getBytes();
        byte[] expectedResponseBytes = "RESPONSE".getBytes();
        SettableFuture settableFuture = SettableFuture.create();
        UdpBindingService senderReceiver1 = this.factory.createUdpBindingService(this.localhostInterface, InetAddress.getByName("239.255.255.250"), Integer.valueOf(3702), Integer.valueOf(4096));
        senderReceiver1.setMessageReceiver(udpMessage -> {
            if (udpMessage.toString().equals("RESPONSE")) {
                settableFuture.set((Object)udpMessage.toString());
            }
        });
        UdpBindingService senderReceiver2 = this.factory.createUdpBindingService(this.localhostInterface, InetAddress.getByName("239.255.255.250"), Integer.valueOf(3702), Integer.valueOf(4096));
        senderReceiver2.setMessageReceiver(udpMessage -> {
            if (udpMessage.toString().equals("REQUEST")) {
                Thread t = new Thread(() -> {
                    try {
                        CommunicationContext ctxt = new CommunicationContext(new ApplicationInfo(), new TransportInfo("soap.udp", null, null, udpMessage.getHost(), udpMessage.getPort(), Collections.emptyList()));
                        senderReceiver2.sendMessage(new UdpMessage(expectedResponseBytes, expectedResponseBytes.length, ctxt));
                    }
                    catch (Exception e) {
                        Assertions.fail();
                    }
                });
                t.start();
            }
        });
        senderReceiver1.startAsync().awaitRunning();
        senderReceiver2.startAsync().awaitRunning();
        Thread t = new Thread(() -> {
            try {
                senderReceiver1.sendMessage(new UdpMessage(expectedRequestBytes, expectedRequestBytes.length));
            }
            catch (Exception e) {
                Assertions.fail();
            }
        });
        t.start();
        Assertions.assertEquals((Object)"RESPONSE", (Object)((String)settableFuture.get(10L, TimeUnit.SECONDS)).substring(0, "RESPONSE".length()));
    }
}

