/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws;

import jregex.Matcher;
import jregex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RFC2396RegexTest {
    private static final Pattern URI_REFERENCE_PATTERN = new Pattern("(({absoluteUri}({scheme}(?i:[a-z][a-z0-9+-.]*)):((((//(((((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;:&=+$,])*)@)?((((([a-zA-Z0-9]|([a-zA-Z0-9]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.)*([a-zA-Z]|([a-zA-Z]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))(\\.)?)|([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+))(:([0-9]*))?))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[$,;:@&=+])+)))((/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))?)|(/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))(\\?({absoluteUriQuery}(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9]))*)))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;?:@&=+$,])(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])))*)))|({relativeUri}((//(((((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;:&=+$,])*)@)?((((([a-zA-Z0-9]|([a-zA-Z0-9]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.)*([a-zA-Z]|([a-zA-Z]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))(\\.)?)|([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+))(:([0-9]*))?))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[$,;:@&=+])+)))((/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))?)|(/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*)))|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;@&=+$,])+((/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))?))(\\?({relativeUriQuery}(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9]))*)))?))?(#({fragment}(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9]))*)))?");
    private static final Pattern RELATIVE_URI_PATTERN = new Pattern("({relativeUri}((//(((((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;:&=+$,])*)@)?((((([a-zA-Z0-9]|([a-zA-Z0-9]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.)*([a-zA-Z]|([a-zA-Z]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))(\\.)?)|([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+))(:([0-9]*))?))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[$,;:@&=+])+)))((/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))?)|(/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*)))|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;@&=+$,])+((/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))?))(\\?({relativeUriQuery}(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9]))*)))?)");
    private static final Pattern ABSOLUTE_URI_PATTERN = new Pattern("({absoluteUri}({scheme}(?i:[a-z][a-z0-9+-.]*)):((((//(((((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;:&=+$,])*)@)?((((([a-zA-Z0-9]|([a-zA-Z0-9]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.)*([a-zA-Z]|([a-zA-Z]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))(\\.)?)|([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+))(:([0-9]*))?))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[$,;:@&=+])+)))((/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))?)|(/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*))))(\\?({absoluteUriQuery}(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9]))*)))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;?:@&=+$,])(([;/?:@&=+$,]|([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])))*)))");
    private static final Pattern AUTHORITY_PATTERN = new Pattern("((((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[;:&=+$,])*)@)?((((([a-zA-Z0-9]|([a-zA-Z0-9]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.)*([a-zA-Z]|([a-zA-Z]([a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))(\\.)?)|([0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+))(:([0-9]*))?))?)|((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[$,;:@&=+])+))");
    private static final Pattern ABS_PATH_PATTERN = new Pattern("(/((((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))((/((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*(;((([a-zA-Z0-9\\-_.!~*'()])|(%[a-fA-F0-9][a-fA-F0-9])|[:@&=+$,])*))*))*)))");

    @Test
    void uriReference() {
        Matcher matcher = URI_REFERENCE_PATTERN.matcher("scheme://user@%C3%A4:123/path?query?query#fragment");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"scheme://user@%C3%A4:123/path?query?query", (Object)matcher.group("absoluteUri"));
        Assertions.assertEquals((Object)"query?query", (Object)matcher.group("absoluteUriQuery"));
        Assertions.assertEquals((Object)"fragment", (Object)matcher.group("fragment"));
        Assertions.assertNull((Object)matcher.group("relativeUri"));
        matcher = URI_REFERENCE_PATTERN.matcher("scheme://user@host:123/path?query?query#fragment");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"scheme://user@host:123/path?query?query", (Object)matcher.group("absoluteUri"));
        Assertions.assertEquals((Object)"query?query", (Object)matcher.group("absoluteUriQuery"));
        Assertions.assertEquals((Object)"fragment", (Object)matcher.group("fragment"));
        Assertions.assertNull((Object)matcher.group("relativeUri"));
        matcher = URI_REFERENCE_PATTERN.matcher("scheme:aaahhh??");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"scheme:aaahhh??", (Object)matcher.group("absoluteUri"));
        Assertions.assertNull((Object)matcher.group("relativeUri"));
        matcher = URI_REFERENCE_PATTERN.matcher("/path?query?query#fragment");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"/path?query?query", (Object)matcher.group("relativeUri"));
        Assertions.assertEquals((Object)"query?query", (Object)matcher.group("relativeUriQuery"));
        Assertions.assertEquals((Object)"fragment", (Object)matcher.group("fragment"));
        Assertions.assertNull((Object)matcher.group("absoluteUri"));
        matcher = URI_REFERENCE_PATTERN.matcher("//user@C3A4:123/path?query?query#fragment");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"//user@C3A4:123/path?query?query", (Object)matcher.group("relativeUri"));
        Assertions.assertEquals((Object)"query?query", (Object)matcher.group("relativeUriQuery"));
        Assertions.assertEquals((Object)"fragment", (Object)matcher.group("fragment"));
        Assertions.assertNull((Object)matcher.group("absoluteUri"));
    }

    @Test
    void absoluteUri() {
        Matcher matcher = ABSOLUTE_URI_PATTERN.matcher("scheme://user@C3A4:123/path?query?query");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"scheme://user@C3A4:123/path?query?query", (Object)matcher.group("absoluteUri"));
        Assertions.assertEquals((Object)"query?query", (Object)matcher.group("absoluteUriQuery"));
        matcher = ABSOLUTE_URI_PATTERN.matcher("scheme:aaahhh??");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"scheme:aaahhh??", (Object)matcher.group("absoluteUri"));
        matcher = ABSOLUTE_URI_PATTERN.matcher("scheme://@@");
        matcher.matches();
        Assertions.assertEquals((Object)"scheme://@@", (Object)matcher.group("absoluteUri"));
        matcher = ABSOLUTE_URI_PATTERN.matcher("scheme://user@C3A4:123/path?#?query#fragment");
        Assertions.assertFalse((boolean)matcher.matches());
        matcher = ABSOLUTE_URI_PATTERN.matcher("urn:example:animal:ferret:nose");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"urn:example:animal:ferret:nose", (Object)matcher.group("absoluteUri"));
        Assertions.assertEquals((Object)"urn", (Object)matcher.group("scheme"));
        matcher = ABSOLUTE_URI_PATTERN.matcher("urn:%2A-");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"urn:%2A-", (Object)matcher.group("absoluteUri"));
        Assertions.assertEquals((Object)"urn", (Object)matcher.group("scheme"));
    }

    @Test
    void relativeUri() {
        Matcher matcher = RELATIVE_URI_PATTERN.matcher("/path?query?query");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"/path?query?query", (Object)matcher.group("relativeUri"));
        Assertions.assertEquals((Object)"query?query", (Object)matcher.group("relativeUriQuery"));
        matcher = RELATIVE_URI_PATTERN.matcher("//user@C3A4:123/path?query?query");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"//user@C3A4:123/path?query?query", (Object)matcher.group("relativeUri"));
        Assertions.assertEquals((Object)"query?query", (Object)matcher.group("relativeUriQuery"));
        matcher = RELATIVE_URI_PATTERN.matcher("*");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"*", (Object)matcher.group("relativeUri"));
    }

    @Test
    void authority() {
        Matcher matcher = AUTHORITY_PATTERN.matcher("user@%C3%A4:123");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"user@%C3%A4:123", (Object)matcher.group(0));
        matcher = AUTHORITY_PATTERN.matcher("user@host:123");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"user@host:123", (Object)matcher.group(0));
        matcher = AUTHORITY_PATTERN.matcher("@@");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"@@", (Object)matcher.group(0));
        matcher = AUTHORITY_PATTERN.matcher("scheme://user@C3A4:123/path?query?query");
        Assertions.assertFalse((boolean)matcher.matches());
        matcher = AUTHORITY_PATTERN.matcher("/path");
        Assertions.assertFalse((boolean)matcher.matches());
    }

    @Test
    void absPath() {
        Matcher matcher = ABS_PATH_PATTERN.matcher("/path");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"/path", (Object)matcher.group(0));
        matcher = ABS_PATH_PATTERN.matcher("/path/path/path");
        Assertions.assertTrue((boolean)matcher.matches());
        Assertions.assertEquals((Object)"/path/path/path", (Object)matcher.group(0));
        matcher = ABS_PATH_PATTERN.matcher("/path/path/path?query");
        Assertions.assertFalse((boolean)matcher.matches());
        matcher = ABS_PATH_PATTERN.matcher("/path/path/path#fragment");
        Assertions.assertFalse((boolean)matcher.matches());
        matcher = ABS_PATH_PATTERN.matcher("scheme://user@C3A4:123/path");
        Assertions.assertFalse((boolean)matcher.matches());
    }
}

