/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBException;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.http.HttpException;
import org.somda.sdc.dpws.http.HttpHandler;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.model.Envelope;

public class TransportBindingFactoryMock
implements TransportBindingFactory {
    private static Map<String, HttpHandler> handlerRegistry;
    private final SoapMarshalling soapMarshalling;
    private final SoapMessageFactory soapMessageFactory;
    private final CommunicationContext mockCommunicationContext;

    @Inject
    TransportBindingFactoryMock(SoapMarshalling soapMarshalling, SoapMessageFactory soapMessageFactory) {
        this.soapMarshalling = soapMarshalling;
        this.soapMessageFactory = soapMessageFactory;
        ArrayListMultimap headers = ArrayListMultimap.create();
        headers.put((Object)"Content-Type", (Object)"application/soap+xml");
        this.mockCommunicationContext = new CommunicationContext((ApplicationInfo)new HttpApplicationInfo((ListMultimap)headers, "mockTransactionId", null), new TransportInfo("mock.scheme", "localhost", Integer.valueOf(123), "remotehost", Integer.valueOf(456), Collections.emptyList()));
    }

    public static void setHandlerRegistry(Map<String, HttpHandler> handlerRegistry) {
        TransportBindingFactoryMock.handlerRegistry = handlerRegistry;
    }

    public TransportBinding createTransportBinding(String endpointUri, @Nullable CommunicationLog communicationLog) {
        if (handlerRegistry == null) {
            handlerRegistry = new HashMap<String, HttpHandler>();
        }
        final Optional<HttpHandler> httpHandler = Optional.ofNullable(handlerRegistry.get(endpointUri));
        return new TransportBinding(){

            public void close() {
            }

            public void onNotification(SoapMessage notification) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    TransportBindingFactoryMock.this.soapMarshalling.marshal(notification.getEnvelopeWithMappedHeaders(), (OutputStream)bos);
                    if (httpHandler.isPresent()) {
                        ((HttpHandler)httpHandler.get()).handle((InputStream)new ByteArrayInputStream(bos.toByteArray()), (OutputStream)new ByteArrayOutputStream(), TransportBindingFactoryMock.this.mockCommunicationContext);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public SoapMessage onRequestResponse(SoapMessage request) throws MarshallingException, TransportException {
                ByteArrayOutputStream bosRequest = new ByteArrayOutputStream();
                try {
                    TransportBindingFactoryMock.this.soapMarshalling.marshal(request.getEnvelopeWithMappedHeaders(), (OutputStream)bosRequest);
                }
                catch (JAXBException e) {
                    throw new MarshallingException((Throwable)e);
                }
                ByteArrayOutputStream bosResponse = new ByteArrayOutputStream();
                HttpHandler theHttpHandler = (HttpHandler)httpHandler.orElseThrow(() -> new TransportException("HTTP handler not set"));
                try {
                    theHttpHandler.handle((InputStream)new ByteArrayInputStream(bosRequest.toByteArray()), (OutputStream)bosResponse, TransportBindingFactoryMock.this.mockCommunicationContext);
                }
                catch (HttpException e) {
                    throw new TransportException((Throwable)e);
                }
                try {
                    Envelope env = TransportBindingFactoryMock.this.soapMarshalling.unmarshal((InputStream)new ByteArrayInputStream(bosResponse.toByteArray()));
                    return TransportBindingFactoryMock.this.soapMessageFactory.createSoapMessage(env);
                }
                catch (JAXBException e) {
                    throw new MarshallingException((Throwable)e);
                }
            }
        };
    }

    public TransportBinding createHttpBinding(String endpointUri, @Nullable CommunicationLog communicationLog) throws UnsupportedOperationException {
        return this.createTransportBinding(endpointUri, communicationLog);
    }
}

