/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.client.helper;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Arrays;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import javax.xml.namespace.QName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.LocalAddressResolverMock;
import org.somda.sdc.dpws.ThisDeviceBuilder;
import org.somda.sdc.dpws.ThisModelBuilder;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.exception.EprAddressMismatchException;
import org.somda.sdc.dpws.client.helper.HostingServiceResolver;
import org.somda.sdc.dpws.guice.ResolverThreadPool;
import org.somda.sdc.dpws.model.HostedServiceType;
import org.somda.sdc.dpws.model.ObjectFactory;
import org.somda.sdc.dpws.model.ThisDeviceType;
import org.somda.sdc.dpws.model.ThisModelType;
import org.somda.sdc.dpws.network.LocalAddressResolver;
import org.somda.sdc.dpws.service.HostedService;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.service.factory.HostingServiceFactory;
import org.somda.sdc.dpws.service.helper.MetadataSectionUtil;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsaddressing.model.ReferenceParametersType;
import org.somda.sdc.dpws.soap.wsmetadataexchange.GetMetadataClient;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.Metadata;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.MetadataSection;
import org.somda.sdc.dpws.soap.wstransfer.TransferGetClient;

class HostingServiceResolverTest
extends DpwsTest {
    private MockTransferGetClient mockTransferGetClient;
    private MockGetMetadataClient mockGetMetadataClient;
    private String expectedDeviceEprAddress;
    private List<QName> expectedHostingServiceQNameTypes;
    private String expectedSerialNumber;
    private ThisDeviceType expectedDeviceType;
    private String expectedModelNumber;
    private ThisModelType expectedModelType;
    private String expectedServiceId;
    private List<EndpointReferenceType> expectedHostedServiceEprs;
    private List<QName> expectedHostedServiceQNameTypes;
    private HostingServiceFactory hostingServiceFactory;
    private org.somda.sdc.dpws.soap.wsmetadataexchange.model.ObjectFactory mexFactory;
    private ObjectFactory dpwsFactory;
    private MetadataSectionUtil metadataSectionUtil;
    private WsAddressingUtil wsaUtil;
    private SoapUtil soapUtil;

    HostingServiceResolverTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.mockTransferGetClient = new MockTransferGetClient();
        this.mockGetMetadataClient = new MockGetMetadataClient();
        this.overrideBindings(new AbstractModule(){

            protected void configure() {
                this.bind(RequestResponseClientFactory.class).toInstance(callback -> (RequestResponseClient)Mockito.mock(RequestResponseClient.class));
                this.bind(TransferGetClient.class).toInstance((Object)HostingServiceResolverTest.this.mockTransferGetClient);
                this.bind(GetMetadataClient.class).toInstance((Object)HostingServiceResolverTest.this.mockGetMetadataClient);
                this.bind(LocalAddressResolver.class).to(LocalAddressResolverMock.class);
            }
        });
        super.setUp();
        ((ExecutorWrapperService)this.getInjector().getInstance(Key.get((TypeLiteral)new TypeLiteral<ExecutorWrapperService<ListeningExecutorService>>(){}, ResolverThreadPool.class))).startAsync().awaitRunning();
        this.wsaUtil = (WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class);
        this.soapUtil = (SoapUtil)this.getInjector().getInstance(SoapUtil.class);
        this.metadataSectionUtil = (MetadataSectionUtil)this.getInjector().getInstance(MetadataSectionUtil.class);
        this.dpwsFactory = (ObjectFactory)this.getInjector().getInstance(ObjectFactory.class);
        this.mexFactory = (org.somda.sdc.dpws.soap.wsmetadataexchange.model.ObjectFactory)this.getInjector().getInstance(org.somda.sdc.dpws.soap.wsmetadataexchange.model.ObjectFactory.class);
        this.hostingServiceFactory = (HostingServiceFactory)this.getInjector().getInstance(HostingServiceFactory.class);
        this.expectedDeviceEprAddress = "urn:uuid:71c219ae-3b55-404f-803b-1e72390f73ba";
        this.expectedHostingServiceQNameTypes = Arrays.asList(new QName("http://device", "Type1"), new QName("http://device", "Type2"));
        this.expectedSerialNumber = "1234-5678-9101-2131";
        ThisDeviceBuilder tdBuilder = (ThisDeviceBuilder)this.getInjector().getInstance(ThisDeviceBuilder.class);
        this.expectedDeviceType = tdBuilder.setSerialNumber(this.expectedSerialNumber).get();
        this.expectedModelNumber = "0815";
        ThisModelBuilder tmBuilder = (ThisModelBuilder)this.getInjector().getInstance(ThisModelBuilder.class);
        this.expectedModelType = tmBuilder.setModelNumber(this.expectedModelNumber).get();
        this.expectedServiceId = "Service1";
        this.expectedHostedServiceEprs = Arrays.asList(this.wsaUtil.createEprWithAddress("http://hosted-service-epr1"), this.wsaUtil.createEprWithAddress("http://hosted-service-epr2"));
        this.expectedHostedServiceQNameTypes = Arrays.asList(new QName("http://service", "Type1"), new QName("http://service", "Type2"));
        HostedServiceType expectedHostedServiceType = this.dpwsFactory.createHostedServiceType();
        expectedHostedServiceType.setEndpointReference(this.expectedHostedServiceEprs);
        expectedHostedServiceType.setServiceId(this.expectedServiceId);
        expectedHostedServiceType.setTypes(this.expectedHostedServiceQNameTypes);
    }

    @Test
    void resolveHostingService() {
        this.mockTransferGetClient.setTransferGetMessages(List.of(this.createTransferGetMessage(this.expectedDeviceEprAddress, this.expectedHostingServiceQNameTypes, this.expectedModelType, this.expectedDeviceType, List.of(this.createHostedService(this.expectedServiceId, this.expectedHostedServiceQNameTypes, this.expectedHostedServiceEprs)))));
        this.mockGetMetadataClient.setGetMetadataMessages(Arrays.asList(this.createGetMetadataMessage(), this.createGetMetadataMessage()));
        HostingServiceResolver hostingServiceResolver = (HostingServiceResolver)this.getInjector().getInstance(HostingServiceResolver.class);
        long expectedMetadataVersion = 100L;
        DiscoveredDevice expectedDiscoveredDevice = this.createDiscoveredDevice(this.expectedDeviceEprAddress, List.of("http://xAddr"), expectedMetadataVersion);
        ListenableFuture hsF = hostingServiceResolver.resolveHostingService(expectedDiscoveredDevice);
        try {
            HostingServiceProxy actualHsp = (HostingServiceProxy)hsF.get();
            Assertions.assertEquals((Object)this.expectedDeviceEprAddress, (Object)actualHsp.getEndpointReferenceAddress());
            Assertions.assertEquals((long)expectedMetadataVersion, (long)actualHsp.getMetadataVersion());
            Assertions.assertTrue((boolean)actualHsp.getThisDevice().isPresent());
            Assertions.assertEquals((Object)this.expectedSerialNumber, (Object)((ThisDeviceType)actualHsp.getThisDevice().get()).getSerialNumber());
            Assertions.assertTrue((boolean)actualHsp.getThisModel().isPresent());
            Assertions.assertEquals((Object)this.expectedModelNumber, (Object)((ThisModelType)actualHsp.getThisModel().get()).getModelNumber());
            Assertions.assertEquals((int)1, (int)actualHsp.getHostedServices().size());
            HostedServiceProxy actualHostedServiceProxy = (HostedServiceProxy)actualHsp.getHostedServices().get(this.expectedServiceId);
            Assertions.assertNotNull((Object)actualHostedServiceProxy);
            Assertions.assertEquals((Object)this.expectedHostedServiceQNameTypes.toString(), (Object)actualHostedServiceProxy.getType().getTypes().toString());
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void resolveHostingServiceWithMismatchedEprAddress() {
        String unexpectedDeviceEprAddress = "00001cb1-af6a-4dfb-ba11-283d88410000";
        this.mockTransferGetClient.setTransferGetMessages(List.of(this.createTransferGetMessage(unexpectedDeviceEprAddress, this.expectedHostingServiceQNameTypes, this.expectedModelType, this.expectedDeviceType, List.of(this.createHostedService(this.expectedServiceId, this.expectedHostedServiceQNameTypes, this.expectedHostedServiceEprs)))));
        this.mockGetMetadataClient.setGetMetadataMessages(Arrays.asList(this.createGetMetadataMessage(), this.createGetMetadataMessage()));
        HostingServiceResolver hostingServiceResolver = (HostingServiceResolver)this.getInjector().getInstance(HostingServiceResolver.class);
        long expectedMetadataVersion = 100L;
        DiscoveredDevice expectedDiscoveredDevice = this.createDiscoveredDevice(this.expectedDeviceEprAddress, List.of("http://xAddr"), expectedMetadataVersion);
        Assertions.assertThrows(EprAddressMismatchException.class, () -> {
            try {
                hostingServiceResolver.resolveHostingService(expectedDiscoveredDevice).get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        });
    }

    private HostedService createHostedService(String serviceId, List<QName> types, List<EndpointReferenceType> eprs) {
        HostedServiceType hst = this.dpwsFactory.createHostedServiceType();
        hst.setTypes(types);
        hst.setServiceId(serviceId);
        hst.setEndpointReference(eprs);
        HostedService hs = (HostedService)Mockito.mock(HostedService.class);
        Mockito.when((Object)hs.getType()).thenReturn((Object)hst);
        return hs;
    }

    private SoapMessage createTransferGetMessage(String eprAddress, List<QName> types, ThisModelType thisModel, ThisDeviceType thisDevice, List<HostedService> hostedServices) {
        Metadata metadata = this.mexFactory.createMetadata();
        List metadataSection = metadata.getMetadataSection();
        metadataSection.add(this.createThisModel(thisModel));
        metadataSection.add(this.createThisDevice(thisDevice));
        metadataSection.add(this.metadataSectionUtil.createRelationship(this.wsaUtil.createEprWithAddress(eprAddress), types, hostedServices));
        metadata.setMetadataSection(metadataSection);
        SoapMessage msg = this.soapUtil.createMessage();
        this.soapUtil.setBody((Object)metadata, msg);
        return msg;
    }

    private SoapMessage createGetMetadataMessage() {
        Metadata metadata = this.mexFactory.createMetadata();
        SoapMessage msg = this.soapUtil.createMessage();
        this.soapUtil.setBody((Object)metadata, msg);
        return msg;
    }

    private MetadataSection createThisModel(ThisModelType modelType) {
        MetadataSection metadataSection = this.mexFactory.createMetadataSection();
        metadataSection.setDialect("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/ThisModel");
        metadataSection.setAny((Object)modelType);
        return metadataSection;
    }

    private MetadataSection createThisDevice(ThisDeviceType deviceType) {
        MetadataSection metadataSection = this.mexFactory.createMetadataSection();
        metadataSection.setDialect("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/ThisDevice");
        metadataSection.setAny((Object)deviceType);
        return metadataSection;
    }

    private DiscoveredDevice createDiscoveredDevice(String deviceUuid, List<String> xAddrs, long version) {
        return new DiscoveredDevice(deviceUuid, (List)Mockito.mock(List.class), (List)Mockito.mock(List.class), xAddrs, version);
    }

    private HostingServiceProxy createHostingServiceProxy(String deviceUuid, long version) {
        return this.hostingServiceFactory.createHostingServiceProxy(deviceUuid, (List)Mockito.mock(List.class), null, null, (Map)Mockito.mock(Map.class), version, (RequestResponseClient)Mockito.mock(RequestResponseClient.class), (String)Mockito.mock(String.class));
    }

    class MockTransferGetClient
    implements TransferGetClient {
        private final Stack<SoapMessage> transferGetMessages = new Stack();

        MockTransferGetClient() {
        }

        void setTransferGetMessages(Collection<SoapMessage> transferGetMessages) {
            this.transferGetMessages.addAll(transferGetMessages);
        }

        public ListenableFuture<SoapMessage> sendTransferGet(RequestResponseClient requestResponseClient, String wsaTo) {
            try {
                return Futures.immediateFuture((Object)this.transferGetMessages.pop());
            }
            catch (EmptyStackException e) {
                throw new RuntimeException("TransferGet message stack empty");
            }
        }

        public ListenableFuture<SoapMessage> sendTransferGet(RequestResponseClient requestResponseClient, String wsaTo, ReferenceParametersType referenceParameters) {
            try {
                return Futures.immediateFuture((Object)this.transferGetMessages.pop());
            }
            catch (EmptyStackException e) {
                throw new RuntimeException("TransferGet message stack empty");
            }
        }
    }

    class MockGetMetadataClient
    implements GetMetadataClient {
        private final Stack<SoapMessage> getMetadataMessages = new Stack();

        MockGetMetadataClient() {
        }

        void setGetMetadataMessages(Collection<SoapMessage> getMetadataMessages) {
            this.getMetadataMessages.addAll(getMetadataMessages);
        }

        public ListenableFuture<SoapMessage> sendGetMetadata(RequestResponseClient requestResponseClient) {
            try {
                return Futures.immediateFuture((Object)this.getMetadataMessages.pop());
            }
            catch (EmptyStackException e) {
                throw new RuntimeException("GetMetadata message stack empty");
            }
        }
    }
}

