/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.service;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.ThisDeviceBuilder;
import org.somda.sdc.dpws.ThisModelBuilder;
import org.somda.sdc.dpws.model.LocalizedStringType;
import org.somda.sdc.dpws.model.ThisDeviceType;
import org.somda.sdc.dpws.model.ThisModelType;
import org.somda.sdc.dpws.service.HostingService;
import org.somda.sdc.dpws.service.factory.HostingServiceFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryTargetService;

class HostingServiceInterceptorTest
extends DpwsTest {
    HostingServiceInterceptorTest() {
    }

    @BeforeEach
    void beforeEach() throws Exception {
        this.setUp();
    }

    @Test
    void thisDeviceMaxSizes() {
        HostingService hostingServiceInterceptor = ((HostingServiceFactory)this.getInjector().getInstance(HostingServiceFactory.class)).createHostingService((WsDiscoveryTargetService)Mockito.mock(WsDiscoveryTargetService.class));
        ThisDeviceType thisDeviceType = new ThisDeviceBuilder().setFriendlyName(this.createTexts(3, 256, "a")).setSerialNumber(this.createText(306, "b")).setFirmwareVersion(this.createText(356, "c")).get();
        hostingServiceInterceptor.setThisDevice(thisDeviceType);
        ThisDeviceType actualThisDevice = hostingServiceInterceptor.getThisDevice();
        this.checkTexts(actualThisDevice.getFriendlyName(), 256, "a");
        this.checkText(actualThisDevice.getSerialNumber(), 256, "b");
        this.checkText(actualThisDevice.getFirmwareVersion(), 256, "c");
    }

    @Test
    void thisModelMaxSizes() {
        HostingService hostingServiceInterceptor = ((HostingServiceFactory)this.getInjector().getInstance(HostingServiceFactory.class)).createHostingService((WsDiscoveryTargetService)Mockito.mock(WsDiscoveryTargetService.class));
        ThisModelType thisModelType = new ThisModelBuilder().setManufacturer(this.createTexts(3, 256, "d")).setModelName(this.createTexts(3, 306, "e")).setModelNumber(this.createText(256, "f")).setPresentationUrl(this.createText(2048, "g")).setManufacturerUrl(this.createText(2048, "h")).setModelUrl(this.createText(2048, "i")).get();
        hostingServiceInterceptor.setThisModel(thisModelType);
        ThisModelType actualThisModel = hostingServiceInterceptor.getThisModel();
        this.checkTexts(actualThisModel.getManufacturer(), 256, "d");
        this.checkTexts(actualThisModel.getModelName(), 256, "e");
        this.checkText(actualThisModel.getModelNumber(), 256, "f");
        this.checkText(actualThisModel.getPresentationUrl(), 2048, "g");
        this.checkText(actualThisModel.getManufacturerUrl(), 2048, "h");
        this.checkText(actualThisModel.getModelUrl(), 2048, "i");
    }

    void checkTexts(List<LocalizedStringType> texts, int size, String repeatedSequence) {
        for (LocalizedStringType text : texts) {
            this.checkText(text.getValue(), size, repeatedSequence);
        }
    }

    void checkText(String text, int size, String repeatedSequence) {
        Assertions.assertEquals((int)(size - 1), (int)text.getBytes(StandardCharsets.UTF_8).length);
        Assertions.assertEquals((Object)this.createText(size - 1, repeatedSequence), (Object)text);
    }

    private List<LocalizedStringType> createTexts(int count, int length, String sequenceToRepeat) {
        ArrayList<LocalizedStringType> texts = new ArrayList<LocalizedStringType>(count);
        for (int i = 0; i < count; ++i) {
            LocalizedStringType localizedStringType = new LocalizedStringType();
            localizedStringType.setValue(this.createText(length, sequenceToRepeat));
            texts.add(localizedStringType);
        }
        return texts;
    }

    private String createText(int length, String sequenceToRepeat) {
        return sequenceToRepeat.repeat(length);
    }
}

