/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import com.google.inject.AbstractModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.somda.sdc.common.guice.AbstractConfigurationModule;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.NetworkSinkMock;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.HelloType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ObjectFactory;

class JaxbSoapMarshallingTest
extends DpwsTest {
    JaxbSoapMarshallingTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.overrideBindings((AbstractModule)new AbstractConfigurationModule(){

            protected void defaultConfigure() {
                this.bind("SoapConfig.ValidateSoapMessages", Boolean.class, false);
            }
        });
        super.setUp();
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).startAsync().awaitRunning();
    }

    @Test
    void marshallCompositeSoapMessage() throws JAXBException, IOException {
        ObjectFactory wsdFactory = (ObjectFactory)this.getInjector().getInstance(ObjectFactory.class);
        HelloType helloType = wsdFactory.createHelloType();
        ArrayList<String> xAddrs = new ArrayList<String>();
        xAddrs.add("http://test-xAddr1");
        xAddrs.add("http://test-xAddr2");
        helloType.setXAddrs(xAddrs);
        JAXBElement expectedHello = wsdFactory.createHello(helloType);
        EnvelopeFactory envelopeFactory = (EnvelopeFactory)this.getInjector().getInstance(EnvelopeFactory.class);
        Envelope expectedEnvelope = envelopeFactory.createEnvelope("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello", "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01", (Object)expectedHello);
        SoapMarshalling marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        NetworkSinkMock mockNetworkSink = (NetworkSinkMock)this.getInjector().getInstance(NetworkSinkMock.class);
        try (OutputStream os = mockNetworkSink.createOutputStream();){
            marshalling.marshal(expectedEnvelope, os);
        }
        try (InputStream inputStreams = mockNetworkSink.getLatest();){
            Envelope actualEnvelope = marshalling.unmarshal(inputStreams);
            Assertions.assertEquals((int)1, (int)actualEnvelope.getBody().getAny().size());
            JAXBElement actualHello = (JAXBElement)actualEnvelope.getBody().getAny().get(0);
            MatcherAssert.assertThat((Object)((HelloType)expectedHello.getValue()).getXAddrs(), (Matcher)CoreMatchers.is((Object)((HelloType)actualHello.getValue()).getXAddrs()));
        }
    }

    @Test
    void marshalFault() throws Exception {
        SoapFaultFactory sff = (SoapFaultFactory)this.getInjector().getInstance(SoapFaultFactory.class);
        SoapMessage faultMsg = sff.createReceiverFault("Test");
        SoapMarshalling marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Envelope envelopeWithMappedHeaders = faultMsg.getEnvelopeWithMappedHeaders();
        marshalling.marshal(envelopeWithMappedHeaders, (OutputStream)bos);
        System.out.println(bos);
        Assertions.assertTrue((boolean)true);
    }

    @Test
    @DisplayName(value="Test whether a marshalled message created using SoapUtil contains the Action element only once")
    void testDuplicateHeaders() throws Exception {
        String action = "ftp://somda.org/upload";
        SoapUtil soapUtil = (SoapUtil)this.getInjector().getInstance(SoapUtil.class);
        SoapMarshalling marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        SoapMessage message = soapUtil.createMessage(action);
        ByteArrayOutputStream messageBaos = new ByteArrayOutputStream();
        marshalling.marshal(message.getEnvelopeWithMappedHeaders(), (OutputStream)messageBaos);
        String messageString = messageBaos.toString(StandardCharsets.UTF_8);
        Assertions.assertEquals((int)2, (int)StringUtils.countMatches((CharSequence)messageString, (CharSequence)":Action>"));
    }

    @Test
    @DisplayName(value="Ignore XML Prolog if Reader encoding is set")
    void testOverrideXmlPrologEncoding() throws Exception {
        String unicodeCharacter = Character.toString('\u00e5');
        String action = "ftp://somda.org/upload" + unicodeCharacter;
        SoapUtil soapUtil = (SoapUtil)this.getInjector().getInstance(SoapUtil.class);
        SoapMarshalling marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        SoapMessage message = soapUtil.createMessage(action);
        ByteArrayOutputStream messageBaos = new ByteArrayOutputStream();
        marshalling.marshal(message.getEnvelopeWithMappedHeaders(), (OutputStream)messageBaos);
        String messageString = messageBaos.toString(StandardCharsets.UTF_8);
        byte[] messageBytes16 = messageString.getBytes(StandardCharsets.UTF_16LE);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(messageBytes16);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_16LE);
        Envelope messageAgain = (Envelope)Assertions.assertDoesNotThrow(() -> marshalling.unmarshal((Reader)reader));
        SoapMessage soapMessageAgain = soapUtil.createMessage(messageAgain);
        Assertions.assertEquals((Object)action, (Object)((AttributedURIType)soapMessageAgain.getWsAddressingHeader().getAction().get()).getValue());
    }
}

