/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsaddressing;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingConstants;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingHeader;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingMapper;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class WsAddressingMapperTest
extends DpwsTest {
    private static final String REFERENCE = "no test for the wicked";
    private WsAddressingMapper mapper;
    private WsAddressingUtil wsaUtil;
    private ObjectFactory wsaFactory;

    WsAddressingMapperTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.mapper = (WsAddressingMapper)this.getInjector().getInstance(WsAddressingMapper.class);
        this.wsaUtil = (WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class);
        this.wsaFactory = (ObjectFactory)this.getInjector().getInstance(ObjectFactory.class);
    }

    @Test
    void testDuplicateJaxbElements() {
        String actionUri = "http://somda.org/someuri";
        String actionUri2 = "ws://somda.org/websocket";
        ArrayList<JAXBElement> actualHeader = new ArrayList<JAXBElement>();
        actualHeader.add(this.wsaFactory.createAction(this.wsaUtil.createAttributedURIType(actionUri)));
        WsAddressingHeader headerContainer = new WsAddressingHeader();
        headerContainer.setAction(this.wsaUtil.createAttributedURIType(actionUri2));
        Assertions.assertEquals((int)1, (int)actualHeader.size());
        Assertions.assertEquals((Object)actionUri, (Object)((AttributedURIType)((JAXBElement)actualHeader.get(0)).getValue()).getValue());
        this.mapper.mapToJaxbSoapHeader(headerContainer, actualHeader);
        Assertions.assertEquals((int)1, (int)actualHeader.size());
        Assertions.assertEquals((Object)actionUri2, (Object)((AttributedURIType)((JAXBElement)actualHeader.get(0)).getValue()).getValue());
        actualHeader = new ArrayList();
        headerContainer = new WsAddressingHeader();
        headerContainer.setAction(this.wsaUtil.createAttributedURIType(actionUri));
        Assertions.assertEquals((int)0, (int)actualHeader.size());
        this.mapper.mapToJaxbSoapHeader(headerContainer, actualHeader);
        Assertions.assertEquals((int)1, (int)actualHeader.size());
        this.mapper.mapToJaxbSoapHeader(headerContainer, actualHeader);
        Assertions.assertEquals((int)1, (int)actualHeader.size());
    }

    @Test
    void testReferenceParameters() {
        Element node = this.createNode();
        ArrayList<Object> actualHeader = new ArrayList<Object>();
        actualHeader.add(node);
        WsAddressingHeader headerContainer = new WsAddressingHeader();
        headerContainer.setMappedReferenceParameters(List.of(node));
        Assertions.assertEquals((int)1, (int)actualHeader.size());
        this.mapper.mapToJaxbSoapHeader(headerContainer, actualHeader);
        Assertions.assertEquals((int)2, (int)actualHeader.size());
        this.mapper.mapToJaxbSoapHeader(headerContainer, actualHeader);
        Assertions.assertEquals((int)3, (int)actualHeader.size());
        actualHeader.forEach(elem -> Assertions.assertTrue((boolean)((Element)elem).hasAttributeNS("http://www.w3.org/2005/08/addressing", WsAddressingConstants.IS_REFERENCE_PARAMETER.getLocalPart())));
    }

    private Element createNode() {
        DocumentBuilder builder;
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        try {
            builder = fac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document doc = builder.newDocument();
        Element root = doc.createElementNS("ftp://namespace.example.com", "MyFunkyRoot");
        root.setTextContent(REFERENCE);
        return root;
    }
}

