/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.common.util.JaxbUtil;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.HttpServerRegistryMock;
import org.somda.sdc.dpws.LocalAddressResolverMock;
import org.somda.sdc.dpws.TransportBindingFactoryMock;
import org.somda.sdc.dpws.device.helper.RequestResponseServerHttpHandler;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.NetworkJobThreadPool;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.http.HttpException;
import org.somda.sdc.dpws.http.HttpHandler;
import org.somda.sdc.dpws.http.HttpServerRegistry;
import org.somda.sdc.dpws.http.HttpUriBuilder;
import org.somda.sdc.dpws.model.HostedServiceType;
import org.somda.sdc.dpws.network.LocalAddressResolver;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.NotificationSink;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.factory.NotificationSinkFactory;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseCallback;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingConstants;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingServerInterceptor;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.ReferenceParametersType;
import org.somda.sdc.dpws.soap.wseventing.EventSink;
import org.somda.sdc.dpws.soap.wseventing.EventSource;
import org.somda.sdc.dpws.soap.wseventing.EventSourceInterceptor;
import org.somda.sdc.dpws.soap.wseventing.MarshallingHelper;
import org.somda.sdc.dpws.soap.wseventing.SubscribeResult;
import org.somda.sdc.dpws.soap.wseventing.factory.SubscriptionManagerFactory;
import org.somda.sdc.dpws.soap.wseventing.factory.WsEventingEventSinkFactory;
import org.somda.sdc.dpws.soap.wseventing.factory.WsEventingFaultFactory;
import org.somda.sdc.dpws.soap.wseventing.helper.SubscriptionRegistry;
import org.somda.sdc.dpws.soap.wseventing.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wseventing.model.SubscribeResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class WsEventingReferenceParametersTest
extends DpwsTest {
    private static final String HOST = "mock-host";
    private static final Integer PORT = 8080;
    private static final String HOSTED_SERVICE_PATH = "/hosted-service";
    private static final String ACTION = "http://action";
    private static final Duration MAX_EXPIRES = Duration.ofHours(3L);
    private static final Duration FUTURE_WAIT = Duration.ofSeconds(1L);
    private static final String REFERENCE = "my_secret_is_cofveve";
    private EventSink wseSink;
    private NotificationSink notificationSink;

    WsEventingReferenceParametersTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.overrideBindings(List.of(new DpwsModuleReplacements()));
        super.setUp();
        ((ExecutorWrapperService)this.getInjector().getInstance(Key.get((TypeLiteral)new TypeLiteral<ExecutorWrapperService<ListeningExecutorService>>(){}, NetworkJobThreadPool.class))).startAsync().awaitRunning();
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).startAsync().awaitRunning();
        WsAddressingUtil wsaUtil = (WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class);
        org.somda.sdc.dpws.model.ObjectFactory dpwsFactory = (org.somda.sdc.dpws.model.ObjectFactory)this.getInjector().getInstance(org.somda.sdc.dpws.model.ObjectFactory.class);
        EventSource wseSource = (EventSource)this.getInjector().getInstance(EventSource.class);
        final RequestResponseServer reqResSrv = (RequestResponseServer)this.getInjector().getInstance(RequestResponseServer.class);
        reqResSrv.register((Interceptor)wseSource);
        this.notificationSink = ((NotificationSinkFactory)this.getInjector().getInstance(NotificationSinkFactory.class)).createNotificationSink((WsAddressingServerInterceptor)this.getInjector().getInstance(WsAddressingServerInterceptor.class));
        HttpServerRegistry httpSrvRegisty = (HttpServerRegistry)this.getInjector().getInstance(HttpServerRegistry.class);
        String uri = "http://mock-host:" + PORT;
        String hostedServiceUri = httpSrvRegisty.registerContext(uri, HOSTED_SERVICE_PATH, new HttpHandler(){

            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) throws HttpException {
                MarshallingHelper.handleRequestResponse(WsEventingReferenceParametersTest.this.getInjector(), reqResSrv, inStream, outStream, communicationContext);
            }
        });
        HostedServiceType hst = dpwsFactory.createHostedServiceType();
        hst.getEndpointReference().add(wsaUtil.createEprWithAddress(hostedServiceUri));
        RequestResponseClientFactory rrcFactory = (RequestResponseClientFactory)this.getInjector().getInstance(RequestResponseClientFactory.class);
        TransportBindingFactory tbFactory = (TransportBindingFactory)this.getInjector().getInstance(TransportBindingFactory.class);
        RequestResponseClient rrc = rrcFactory.createRequestResponseClient((RequestResponseCallback)tbFactory.createTransportBinding(hostedServiceUri, null));
        this.wseSink = ((WsEventingEventSinkFactory)this.getInjector().getInstance(WsEventingEventSinkFactory.class)).createWsEventingEventSink(rrc, "http://localhost:1234", null);
    }

    void verifyReferenceParam(SettableFuture<Collection<Element>> future) throws Exception {
        Collection incomingRefParm = (Collection)future.get(FUTURE_WAIT.toSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)incomingRefParm.size());
        Optional firstFind = incomingRefParm.stream().findFirst();
        Assertions.assertTrue((boolean)firstFind.isPresent());
        Element element = (Element)firstFind.get();
        Assertions.assertEquals((int)1, (int)element.getChildNodes().getLength());
        Assertions.assertEquals((Object)REFERENCE, (Object)element.getTextContent());
        Assertions.assertTrue((boolean)element.hasAttributeNS(WsAddressingConstants.IS_REFERENCE_PARAMETER.getNamespaceURI(), WsAddressingConstants.IS_REFERENCE_PARAMETER.getLocalPart()));
    }

    @Test
    void referenceParameterInUnsubscribe() throws Exception {
        Assertions.assertFalse((boolean)EventSourceInterceptorMock.unsubscribeRefParam.isDone());
        Duration expectedExpires = Duration.ofHours(1L);
        ListenableFuture resInfo = this.wseSink.subscribe(Collections.singletonList(ACTION), expectedExpires, this.notificationSink);
        MatcherAssert.assertThat((String)"Granted expires duration", (Object)((SubscribeResult)resInfo.get()).getGrantedExpires(), (Matcher)Matchers.is((Object)expectedExpires));
        this.wseSink.getStatus(((SubscribeResult)resInfo.get()).getSubscriptionId()).get();
        this.wseSink.unsubscribe(((SubscribeResult)resInfo.get()).getSubscriptionId()).get();
        this.verifyReferenceParam(EventSourceInterceptorMock.unsubscribeRefParam);
    }

    @Test
    void referenceParameterInGetStatus() throws Exception {
        Assertions.assertFalse((boolean)EventSourceInterceptorMock.getStatusRefParam.isDone());
        Duration expectedExpires = Duration.ofHours(1L);
        ListenableFuture resInfo = this.wseSink.subscribe(Collections.singletonList(ACTION), expectedExpires, this.notificationSink);
        MatcherAssert.assertThat((String)"Granted expires duration", (Object)((SubscribeResult)resInfo.get()).getGrantedExpires(), (Matcher)Matchers.is((Object)expectedExpires));
        this.wseSink.getStatus(((SubscribeResult)resInfo.get()).getSubscriptionId()).get();
        this.wseSink.unsubscribe(((SubscribeResult)resInfo.get()).getSubscriptionId()).get();
        this.verifyReferenceParam(EventSourceInterceptorMock.getStatusRefParam);
    }

    @Test
    void referenceParameterInRenew() throws Exception {
        Assertions.assertFalse((boolean)EventSourceInterceptorMock.renewRefParam.isDone());
        Duration expectedExpires = Duration.ofHours(1L);
        ListenableFuture resInfo = this.wseSink.subscribe(Collections.singletonList(ACTION), expectedExpires, this.notificationSink);
        MatcherAssert.assertThat((String)"Granted expires duration", (Object)((SubscribeResult)resInfo.get()).getGrantedExpires(), (Matcher)Matchers.is((Object)expectedExpires));
        this.wseSink.getStatus(((SubscribeResult)resInfo.get()).getSubscriptionId()).get();
        this.wseSink.renew(((SubscribeResult)resInfo.get()).getSubscriptionId(), MAX_EXPIRES).get();
        this.wseSink.unsubscribe(((SubscribeResult)resInfo.get()).getSubscriptionId()).get();
        this.verifyReferenceParam(EventSourceInterceptorMock.renewRefParam);
    }

    private class DpwsModuleReplacements
    extends AbstractModule {
        private DpwsModuleReplacements() {
        }

        protected void configure() {
            TransportBindingFactoryMock.setHandlerRegistry(HttpServerRegistryMock.getRegistry());
            this.bind(EventSource.class).to(EventSourceInterceptorMock.class);
            this.bind(Duration.class).annotatedWith((Annotation)Names.named((String)"WsEventing.Source.MaxExpires")).toInstance((Object)Duration.ofHours(3L));
            this.bind(HttpServerRegistry.class).to(HttpServerRegistryMock.class);
            this.bind(TransportBindingFactory.class).to(TransportBindingFactoryMock.class);
            this.bind(LocalAddressResolver.class).to(LocalAddressResolverMock.class);
        }
    }

    public static class EventSourceInterceptorMock
    extends EventSourceInterceptor {
        static SettableFuture<Collection<Element>> unsubscribeRefParam = SettableFuture.create();
        static SettableFuture<Collection<Element>> getStatusRefParam = SettableFuture.create();
        static SettableFuture<Collection<Element>> renewRefParam = SettableFuture.create();
        private final SoapUtil soapUtil;

        @Inject
        EventSourceInterceptorMock(@Named(value="WsEventing.Source.MaxExpires") Duration maxExpires, @Named(value="WsEventing.Source.SubscriptionManagerPath") String subscriptionManagerPath, SoapUtil soapUtil, WsEventingFaultFactory faultFactory, JaxbUtil jaxbUtil, WsAddressingUtil wsaUtil, ObjectFactory wseFactory, SoapMessageFactory soapMessageFactory, EnvelopeFactory envelopeFactory, HttpServerRegistry httpServerRegistry, Provider<RequestResponseServerHttpHandler> rrServerHttpHandlerProvider, SubscriptionRegistry subscriptionRegistry, SubscriptionManagerFactory subscriptionManagerFactory, HttpUriBuilder httpUriBuilder) {
            super(maxExpires, subscriptionManagerPath, soapUtil, faultFactory, jaxbUtil, wsaUtil, wseFactory, soapMessageFactory, envelopeFactory, httpServerRegistry, rrServerHttpHandlerProvider, subscriptionRegistry, subscriptionManagerFactory, httpUriBuilder, "abcd");
            this.soapUtil = soapUtil;
            unsubscribeRefParam = SettableFuture.create();
            getStatusRefParam = SettableFuture.create();
            renewRefParam = SettableFuture.create();
        }

        @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe", direction=Direction.REQUEST)
        void processSubscribe(RequestResponseObject rrObj) throws SoapFaultException {
            DocumentBuilder builder;
            super.processSubscribe(rrObj);
            ReferenceParametersType referenceParameters = new ReferenceParametersType();
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            try {
                builder = fac.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            Document doc = builder.newDocument();
            Element root = doc.createElementNS("ftp://namespace.example.com", "MyFunkyRoot");
            root.setTextContent(WsEventingReferenceParametersTest.REFERENCE);
            referenceParameters.setAny(List.of(root));
            SubscribeResponse body = (SubscribeResponse)this.soapUtil.getBody(rrObj.getResponse(), SubscribeResponse.class).orElseThrow(() -> new RuntimeException("err"));
            body.getSubscriptionManager().setReferenceParameters(referenceParameters);
            this.soapUtil.setBody((Object)body, rrObj.getResponse());
        }

        @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe", direction=Direction.REQUEST)
        void processUnsubscribe(RequestResponseObject rrObj) throws SoapFaultException {
            super.processUnsubscribe(rrObj);
            Optional refParm = rrObj.getRequest().getWsAddressingHeader().getMappedReferenceParameters();
            refParm.ifPresent(refParmContent -> unsubscribeRefParam.set(refParmContent));
        }

        @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus", direction=Direction.REQUEST)
        void processGetStatus(RequestResponseObject rrObj) throws SoapFaultException {
            super.processGetStatus(rrObj);
            Optional refParm = rrObj.getRequest().getWsAddressingHeader().getMappedReferenceParameters();
            refParm.ifPresent(refParmContent -> getStatusRefParam.set(refParmContent));
        }

        @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew", direction=Direction.REQUEST)
        void processRenew(RequestResponseObject rrObj) throws SoapFaultException {
            super.processRenew(rrObj);
            Optional refParm = rrObj.getRequest().getWsAddressingHeader().getMappedReferenceParameters();
            refParm.ifPresent(refParmContent -> renewRefParam.set(refParmContent));
        }
    }
}

