/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.HttpServerRegistryMock;
import org.somda.sdc.dpws.LocalAddressResolverMock;
import org.somda.sdc.dpws.TransportBindingFactoryMock;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.NetworkJobThreadPool;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.http.HttpException;
import org.somda.sdc.dpws.http.HttpHandler;
import org.somda.sdc.dpws.http.HttpServerRegistry;
import org.somda.sdc.dpws.model.HostedServiceType;
import org.somda.sdc.dpws.model.ObjectFactory;
import org.somda.sdc.dpws.network.LocalAddressResolver;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.NotificationSink;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.factory.NotificationSinkFactory;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseCallback;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingServerInterceptor;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wseventing.EventSink;
import org.somda.sdc.dpws.soap.wseventing.EventSource;
import org.somda.sdc.dpws.soap.wseventing.MarshallingHelper;
import org.somda.sdc.dpws.soap.wseventing.SubscribeResult;
import org.somda.sdc.dpws.soap.wseventing.factory.WsEventingEventSinkFactory;
import org.somda.sdc.dpws.soap.wseventing.model.WsEventingStatus;

class WsEventingTest
extends DpwsTest {
    private static final String HOST = "mock-host";
    private static final Integer PORT = 8080;
    private static final String HOSTED_SERVICE_PATH = "/hosted-service";
    private static final String ACTION = "http://action";
    private static final Duration MAX_EXPIRES = Duration.ofHours(3L);
    private static final Duration MAX_WAIT = Duration.ofSeconds(5L);
    private EventSink wseSink;
    private NotificationSink notificationSink;
    private EventSource wseSource;

    WsEventingTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.overrideBindings(new DpwsModuleReplacements());
        super.setUp();
        ((ExecutorWrapperService)this.getInjector().getInstance(Key.get((TypeLiteral)new TypeLiteral<ExecutorWrapperService<ListeningExecutorService>>(){}, NetworkJobThreadPool.class))).startAsync().awaitRunning();
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).startAsync().awaitRunning();
        WsAddressingUtil wsaUtil = (WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class);
        ObjectFactory dpwsFactory = (ObjectFactory)this.getInjector().getInstance(ObjectFactory.class);
        this.wseSource = (EventSource)this.getInjector().getInstance(EventSource.class);
        final RequestResponseServer reqResSrv = (RequestResponseServer)this.getInjector().getInstance(RequestResponseServer.class);
        reqResSrv.register((Interceptor)this.wseSource);
        this.notificationSink = ((NotificationSinkFactory)this.getInjector().getInstance(NotificationSinkFactory.class)).createNotificationSink((WsAddressingServerInterceptor)this.getInjector().getInstance(WsAddressingServerInterceptor.class));
        HttpServerRegistry httpSrvRegistry = (HttpServerRegistry)this.getInjector().getInstance(HttpServerRegistry.class);
        String uri = "http://mock-host:" + PORT;
        String hostedServiceUri = httpSrvRegistry.registerContext(uri, HOSTED_SERVICE_PATH, new HttpHandler(){

            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) throws HttpException {
                MarshallingHelper.handleRequestResponse(WsEventingTest.this.getInjector(), reqResSrv, inStream, outStream, communicationContext);
            }
        });
        HostedServiceType hst = dpwsFactory.createHostedServiceType();
        hst.getEndpointReference().add(wsaUtil.createEprWithAddress(hostedServiceUri));
        RequestResponseClientFactory rrcFactory = (RequestResponseClientFactory)this.getInjector().getInstance(RequestResponseClientFactory.class);
        TransportBindingFactory tbFactory = (TransportBindingFactory)this.getInjector().getInstance(TransportBindingFactory.class);
        RequestResponseClient rrc = rrcFactory.createRequestResponseClient((RequestResponseCallback)tbFactory.createTransportBinding(hostedServiceUri, null));
        this.wseSink = ((WsEventingEventSinkFactory)this.getInjector().getInstance(WsEventingEventSinkFactory.class)).createWsEventingEventSink(rrc, "http://localhost:1234", null);
    }

    @Test
    void subscribe() throws Exception {
        Duration expectedExpires = MAX_EXPIRES;
        ListenableFuture resInfo = this.wseSink.subscribe(Collections.singletonList(ACTION), expectedExpires, this.notificationSink);
        MatcherAssert.assertThat((String)"Subscription ID length", (Object)((SubscribeResult)resInfo.get()).getSubscriptionId().length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Granted expires duration", (Object)((SubscribeResult)resInfo.get()).getGrantedExpires(), (Matcher)Matchers.is((Object)expectedExpires));
        Duration tryExpires = MAX_EXPIRES.plusHours(1L);
        resInfo = this.wseSink.subscribe(Collections.singletonList(ACTION), tryExpires, this.notificationSink);
        MatcherAssert.assertThat((String)"Second subscription ID length", (Object)((SubscribeResult)resInfo.get()).getSubscriptionId().length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Seconds granted expires duration", (Object)((SubscribeResult)resInfo.get()).getGrantedExpires(), (Matcher)Matchers.is((Object)MAX_EXPIRES));
        resInfo = this.wseSink.subscribe(Collections.singletonList(ACTION), null, this.notificationSink);
        MatcherAssert.assertThat((String)"Second subscription ID length", (Object)((SubscribeResult)resInfo.get()).getSubscriptionId().length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((String)"Seconds granted expires duration", (Object)((SubscribeResult)resInfo.get()).getGrantedExpires(), (Matcher)Matchers.is((Object)MAX_EXPIRES));
    }

    @Test
    void renew() throws Exception {
        Duration expectedExpires = Duration.ofHours(1L);
        ListenableFuture resInfo = this.wseSink.subscribe(Collections.singletonList(ACTION), expectedExpires, this.notificationSink);
        MatcherAssert.assertThat((String)"Granted expires duration", (Object)((SubscribeResult)resInfo.get()).getGrantedExpires(), (Matcher)Matchers.is((Object)expectedExpires));
        expectedExpires = Duration.ofHours(2L);
        ListenableFuture actualExpires = this.wseSink.renew(((SubscribeResult)resInfo.get()).getSubscriptionId(), expectedExpires);
        MatcherAssert.assertThat((String)"Renew granted expires duration", (Object)((Duration)actualExpires.get()), (Matcher)Matchers.is((Object)expectedExpires));
    }

    @Test
    void getStatus() throws Exception {
        Duration expectedExpires = Duration.ofHours(1L);
        ListenableFuture resInfo = this.wseSink.subscribe(Collections.singletonList(ACTION), expectedExpires, this.notificationSink);
        MatcherAssert.assertThat((String)"Granted expires duration", (Object)((SubscribeResult)resInfo.get()).getGrantedExpires(), (Matcher)Matchers.is((Object)expectedExpires));
        Thread.sleep(1000L);
        ListenableFuture actualExpires = this.wseSink.getStatus(((SubscribeResult)resInfo.get()).getSubscriptionId());
        MatcherAssert.assertThat((String)"GetStatus retrieved expires duration", (Object)((Duration)actualExpires.get()), (Matcher)Matchers.lessThan((Comparable)expectedExpires));
        MatcherAssert.assertThat((String)"GetStatus retrieved expires duration", (Object)((Duration)actualExpires.get()), (Matcher)Matchers.greaterThan((Comparable)Duration.ZERO));
    }

    @Test
    void unsubscribe() throws Exception {
        Duration expectedExpires = Duration.ofHours(1L);
        ListenableFuture resInfo = this.wseSink.subscribe(Collections.singletonList(ACTION), expectedExpires, this.notificationSink);
        MatcherAssert.assertThat((String)"Granted expires duration", (Object)((SubscribeResult)resInfo.get()).getGrantedExpires(), (Matcher)Matchers.is((Object)expectedExpires));
        this.wseSink.getStatus(((SubscribeResult)resInfo.get()).getSubscriptionId()).get();
        this.wseSink.unsubscribe(((SubscribeResult)resInfo.get()).getSubscriptionId()).get();
        try {
            this.wseSink.getStatus(((SubscribeResult)resInfo.get()).getSubscriptionId()).get();
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    @Test
    void subscriptionEndNoStale() throws Exception {
        Duration expectedExpires = Duration.ofSeconds(1L);
        NotificationSink spySink = (NotificationSink)Mockito.spy((Object)this.notificationSink);
        SubscribeResult resInfo = (SubscribeResult)this.wseSink.subscribe(Collections.singletonList(ACTION), expectedExpires, spySink).get(MAX_WAIT.toSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedExpires, (Object)resInfo.getGrantedExpires(), (String)"Expected expires not matching actual expires");
        Thread.sleep(1000L + expectedExpires.toMillis());
        this.wseSource.subscriptionEndToAll(WsEventingStatus.STATUS_SOURCE_CANCELLING);
        Thread.sleep(1000L);
        ((NotificationSink)Mockito.verify((Object)spySink, (VerificationMode)Mockito.times((int)0))).receiveNotification((SoapMessage)ArgumentMatchers.any(), (CommunicationContext)ArgumentMatchers.any());
    }

    private static class DpwsModuleReplacements
    extends AbstractModule {
        private DpwsModuleReplacements() {
        }

        protected void configure() {
            TransportBindingFactoryMock.setHandlerRegistry(HttpServerRegistryMock.getRegistry());
            this.bind(Duration.class).annotatedWith((Annotation)Names.named((String)"WsEventing.Source.MaxExpires")).toInstance((Object)Duration.ofHours(3L));
            this.bind(HttpServerRegistry.class).to(HttpServerRegistryMock.class);
            this.bind(TransportBindingFactory.class).to(TransportBindingFactoryMock.class);
            this.bind(LocalAddressResolver.class).to(LocalAddressResolverMock.class);
        }
    }
}

