/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.somda.sdc.dpws.LocalizedStringsBuilder;
import org.somda.sdc.dpws.ThisDeviceBuilder;
import org.somda.sdc.dpws.ThisModelBuilder;
import org.somda.sdc.dpws.model.LocalizedStringType;
import org.somda.sdc.dpws.model.ObjectFactory;
import org.somda.sdc.dpws.model.ThisDeviceType;
import org.somda.sdc.dpws.model.ThisModelType;

public class DpwsUtil {
    private final ObjectFactory dpwsFactory;

    @Inject
    DpwsUtil(ObjectFactory dpwsFactory) {
        this.dpwsFactory = dpwsFactory;
    }

    public ThisDeviceType createThisDevice(List<LocalizedStringType> friendlyName, @Nullable String firmwareVersion, @Nullable String serialNumber) {
        ThisDeviceType devType = this.dpwsFactory.createThisDeviceType();
        devType.setFriendlyName(friendlyName);
        Optional.ofNullable(firmwareVersion).ifPresent(arg_0 -> ((ThisDeviceType)devType).setFirmwareVersion(arg_0));
        Optional.ofNullable(serialNumber).ifPresent(arg_0 -> ((ThisDeviceType)devType).setSerialNumber(arg_0));
        return devType;
    }

    public ThisDeviceBuilder createDeviceBuilder() {
        return new ThisDeviceBuilder();
    }

    public ThisDeviceBuilder createDeviceBuilder(List<LocalizedStringType> friendlyName) {
        return new ThisDeviceBuilder(friendlyName);
    }

    public ThisModelBuilder createModelBuilder() {
        return new ThisModelBuilder();
    }

    public ThisModelBuilder createModelBuilder(List<LocalizedStringType> manufacturer, List<LocalizedStringType> modelName) {
        return new ThisModelBuilder(manufacturer, modelName);
    }

    public ThisModelType createThisModel(List<LocalizedStringType> manufacturer, @Nullable String manufacturerUrl, List<LocalizedStringType> modelName, @Nullable String modelNumber, @Nullable String modelUrl, @Nullable String presentationUrl) {
        ThisModelType modType = this.dpwsFactory.createThisModelType();
        modType.setManufacturer(manufacturer);
        Optional.ofNullable(manufacturerUrl).ifPresent(arg_0 -> ((ThisModelType)modType).setManufacturerUrl(arg_0));
        modType.setModelName(modelName);
        Optional.ofNullable(modelNumber).ifPresent(arg_0 -> ((ThisModelType)modType).setModelNumber(arg_0));
        Optional.ofNullable(modelUrl).ifPresent(arg_0 -> ((ThisModelType)modType).setModelUrl(arg_0));
        Optional.ofNullable(presentationUrl).ifPresent(arg_0 -> ((ThisModelType)modType).setPresentationUrl(arg_0));
        return modType;
    }

    public LocalizedStringsBuilder createLocalizedStrings(String lang, String text) {
        return new LocalizedStringsBuilder(lang, text);
    }

    public LocalizedStringsBuilder createLocalizedStrings(String text) {
        return new LocalizedStringsBuilder(text);
    }

    public LocalizedStringsBuilder createLocalizedStrings() {
        return new LocalizedStringsBuilder();
    }
}

