/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.client;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.client.Client;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.DiscoveryFilter;
import org.somda.sdc.dpws.client.DiscoveryObserver;
import org.somda.sdc.dpws.client.helper.DiscoveredDeviceResolver;
import org.somda.sdc.dpws.client.helper.DiscoveryClientUdpProcessor;
import org.somda.sdc.dpws.client.helper.HelloByeAndProbeMatchesObserverImpl;
import org.somda.sdc.dpws.client.helper.HostingServiceResolver;
import org.somda.sdc.dpws.client.helper.factory.ClientHelperFactory;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.ClientSpecific;
import org.somda.sdc.dpws.guice.DiscoveryUdpQueue;
import org.somda.sdc.dpws.guice.NetworkJobThreadPool;
import org.somda.sdc.dpws.helper.NotificationSourceUdpCallback;
import org.somda.sdc.dpws.helper.factory.DpwsHelperFactory;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.NotificationSink;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.NotificationSinkFactory;
import org.somda.sdc.dpws.soap.factory.NotificationSourceFactory;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingServerInterceptor;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsdiscovery.HelloByeAndProbeMatchesObserver;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryClient;
import org.somda.sdc.dpws.soap.wsdiscovery.factory.WsDiscoveryClientFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchesType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchesType;
import org.somda.sdc.dpws.udp.UdpMessageQueueService;

public class ClientImpl
extends AbstractIdleService
implements Client,
Service,
HelloByeAndProbeMatchesObserver {
    private static final Logger LOG = LogManager.getLogger(ClientImpl.class);
    private final UdpMessageQueueService discoveryMessageQueue;
    private final HostingServiceResolver hostingServiceResolver;
    private final DiscoveryClientUdpProcessor msgProcessor;
    private final HelloByeAndProbeMatchesObserverImpl helloByeAndProbeMatchesObserverImpl;
    private final WsDiscoveryClient wsDiscoveryClient;
    private final ExecutorWrapperService<ListeningExecutorService> executorService;
    private final WsAddressingUtil wsAddressingUtil;
    private final TransportBindingFactory transportBindingFactory;
    private final RequestResponseClientFactory requestResponseClientFactory;
    private final Duration maxWaitForFutures;
    private final Logger instanceLogger;

    @Inject
    ClientImpl(@Named(value="Dpws.MaxWaitForFutures") Duration maxWaitForFutures, WsDiscoveryClientFactory discoveryClientFactory, NotificationSourceFactory notificationSourceFactory, DpwsHelperFactory dpwsHelperFactory, @DiscoveryUdpQueue UdpMessageQueueService discoveryMessageQueue, NotificationSinkFactory notificationSinkFactory, ClientHelperFactory clientHelperFactory, @NetworkJobThreadPool ExecutorWrapperService<ListeningExecutorService> executorService, WsAddressingUtil wsAddressingUtil, TransportBindingFactory transportBindingFactory, RequestResponseClientFactory requestResponseClientFactory, HostingServiceResolver hostingServiceResolver, @ClientSpecific WsAddressingServerInterceptor wsAddressingServerInterceptor, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.maxWaitForFutures = maxWaitForFutures;
        this.discoveryMessageQueue = discoveryMessageQueue;
        this.hostingServiceResolver = hostingServiceResolver;
        this.executorService = executorService;
        this.wsAddressingUtil = wsAddressingUtil;
        this.transportBindingFactory = transportBindingFactory;
        this.requestResponseClientFactory = requestResponseClientFactory;
        NotificationSourceUdpCallback callback = dpwsHelperFactory.createNotificationSourceUdpCallback(discoveryMessageQueue);
        NotificationSource notificationSource = notificationSourceFactory.createNotificationSource(callback);
        this.wsDiscoveryClient = discoveryClientFactory.createWsDiscoveryClient(notificationSource);
        NotificationSink notificationSink = notificationSinkFactory.createNotificationSink(wsAddressingServerInterceptor);
        this.msgProcessor = clientHelperFactory.createDiscoveryClientUdpProcessor(notificationSink);
        notificationSink.register(this.wsDiscoveryClient);
        DiscoveredDeviceResolver discoveredDeviceResolver = clientHelperFactory.createDiscoveredDeviceResolver(this.wsDiscoveryClient);
        this.helloByeAndProbeMatchesObserverImpl = clientHelperFactory.createDiscoveryObserver(discoveredDeviceResolver);
    }

    @Override
    public void probe(DiscoveryFilter discoveryFilter) throws TransportException, InterceptorException {
        this.checkRunning();
        try {
            this.wsDiscoveryClient.sendProbe(discoveryFilter.getDiscoveryId(), discoveryFilter.getTypes(), discoveryFilter.getScopes());
        }
        catch (MarshallingException e) {
            this.instanceLogger.error("Marshalling failed while probing for devices", e.getCause());
        }
    }

    @Override
    public ListenableFuture<ProbeMatchesType> directedProbe(String xAddr) {
        this.checkRunning();
        TransportBinding tBinding = this.transportBindingFactory.createTransportBinding(xAddr, null);
        RequestResponseClient rrc = this.requestResponseClientFactory.createRequestResponseClient(tBinding);
        return this.wsDiscoveryClient.sendDirectedProbe(rrc, new ArrayList<QName>(), new ArrayList<String>());
    }

    @Override
    public ListenableFuture<DiscoveredDevice> resolve(String eprAddress) throws InterceptorException {
        this.checkRunning();
        try {
            final SettableFuture deviceSettableFuture = SettableFuture.create();
            ListenableFuture<ResolveMatchesType> resolveMatchesFuture = this.wsDiscoveryClient.sendResolve(this.wsAddressingUtil.createEprWithAddress(eprAddress));
            Futures.addCallback(resolveMatchesFuture, (FutureCallback)new FutureCallback<ResolveMatchesType>(){

                public void onSuccess(@Nullable ResolveMatchesType resolveMatchesType) {
                    if (resolveMatchesType == null) {
                        ClientImpl.this.instanceLogger.warn("Received ResolveMatches with empty payload");
                    } else {
                        ResolveMatchType rm = resolveMatchesType.getResolveMatch();
                        List scopes = Collections.emptyList();
                        if (rm.getScopes() != null) {
                            scopes = rm.getScopes().getValue();
                        }
                        deviceSettableFuture.set((Object)new DiscoveredDevice(rm.getEndpointReference().getAddress().getValue(), rm.getTypes(), scopes, rm.getXAddrs(), rm.getMetadataVersion()));
                    }
                }

                public void onFailure(Throwable throwable) {
                    ClientImpl.this.instanceLogger.trace("Resolve failed.", throwable);
                    deviceSettableFuture.setException(throwable);
                }
            }, (Executor)this.executorService.get());
            return deviceSettableFuture;
        }
        catch (MarshallingException e) {
            this.instanceLogger.warn("Marshalling failed while probing for devices", e.getCause());
            SettableFuture errorFuture = SettableFuture.create();
            errorFuture.setException((Throwable)e);
            return errorFuture;
        }
        catch (TransportException e) {
            this.instanceLogger.warn("Sending failed on transport layer", e.getCause());
            SettableFuture errorFuture = SettableFuture.create();
            errorFuture.setException((Throwable)e);
            return errorFuture;
        }
    }

    @Override
    public ListenableFuture<HostingServiceProxy> connect(DiscoveredDevice discoveredDevice) {
        this.checkRunning();
        return this.hostingServiceResolver.resolveHostingService(discoveredDevice);
    }

    @Override
    public ListenableFuture<HostingServiceProxy> connect(final String eprAddress) throws InterceptorException {
        this.checkRunning();
        ListenableFuture<DiscoveredDevice> resolveFuture = this.resolve(eprAddress);
        final SettableFuture hspFuture = SettableFuture.create();
        Futures.addCallback(resolveFuture, (FutureCallback)new FutureCallback<DiscoveredDevice>(){

            public void onSuccess(@Nullable DiscoveredDevice discoveredDevice) {
                if (discoveredDevice == null) {
                    throw new RuntimeException(String.format("Resolve of %s failed", eprAddress));
                }
                ListenableFuture<HostingServiceProxy> connectFuture = ClientImpl.this.connect(discoveredDevice);
                try {
                    hspFuture.set((Object)((HostingServiceProxy)connectFuture.get(ClientImpl.this.maxWaitForFutures.toMillis(), TimeUnit.MILLISECONDS)));
                }
                catch (TimeoutException e) {
                    connectFuture.cancel(true);
                    ClientImpl.this.instanceLogger.debug("Connecting to {} timed out after {} seconds", (Object)eprAddress, (Object)ClientImpl.this.maxWaitForFutures.toSeconds(), (Object)e);
                    throw new RuntimeException(String.format("Connect of %s timed out after %s seconds", eprAddress, ClientImpl.this.maxWaitForFutures.toSeconds()));
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    ClientImpl.this.instanceLogger.debug("Connecting to {} failed", (Object)eprAddress, (Object)e);
                    throw new RuntimeException(String.format("Connect of %s failed", eprAddress));
                }
            }

            public void onFailure(Throwable throwable) {
                ClientImpl.this.instanceLogger.trace("Connecting to endpoint {} failed", (Object)eprAddress, (Object)throwable);
                hspFuture.setException(throwable);
            }
        }, (Executor)this.executorService.get());
        return hspFuture;
    }

    protected void startUp() {
        this.discoveryMessageQueue.registerUdpMessageQueueObserver(this.msgProcessor);
        this.wsDiscoveryClient.registerHelloByeAndProbeMatchesObserver(this.helloByeAndProbeMatchesObserverImpl);
    }

    protected void shutDown() {
        this.wsDiscoveryClient.unregisterHelloByeAndProbeMatchesObserver(this.helloByeAndProbeMatchesObserverImpl);
        this.discoveryMessageQueue.unregisterUdpMessageQueueObserver(this.msgProcessor);
    }

    @Override
    public void registerDiscoveryObserver(DiscoveryObserver observer) {
        this.helloByeAndProbeMatchesObserverImpl.registerDiscoveryObserver(observer);
    }

    @Override
    public void unregisterDiscoveryObserver(DiscoveryObserver observer) {
        this.helloByeAndProbeMatchesObserverImpl.unregisterDiscoveryObserver(observer);
    }

    private void checkRunning() {
        if (!this.isRunning()) {
            String msg = "Try to invoke method on non-running client";
            this.instanceLogger.warn(msg);
            throw new RuntimeException(msg);
        }
    }
}

